/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import net.nicholaswilliams.java.licensing.SignedLicense;
import net.nicholaswilliams.java.licensing.encryption.PasswordProvider;
import net.nicholaswilliams.java.licensing.encryption.PrivateKeyDataProvider;
import net.nicholaswilliams.java.licensing.exception.KeyNotFoundException;
import org.gluu.oxd.license.client.data.LicenseResponse;
import org.gluu.oxd.license.client.lib.ALicense;
import org.gluu.oxd.license.client.lib.LicenseSerializationUtilities;
import org.gluu.oxd.licenser.server.LicenseCreator;
import org.gluu.oxd.licenser.server.LicenseGeneratorInput;

public class LicenseGenerator {
    public SignedLicense generateSignedLicense(final LicenseGeneratorInput input) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKeyDataProvider privateKeyDataProvider = new PrivateKeyDataProvider(){

            public byte[] getEncryptedPrivateKeyData() throws KeyNotFoundException {
                return input.getPrivateKey();
            }
        };
        PasswordProvider privatePasswordProvider = new PasswordProvider(){

            public char[] getPassword() {
                return input.getPrivatePassword().toCharArray();
            }
        };
        LicenseCreator licenseCreator = new LicenseCreator(privateKeyDataProvider, privatePasswordProvider);
        ALicense license = new ALicense.Builder().withSubject(input.getMetadata()).withHolder("Gluu").withGoodBeforeDate(input.getExpiredAt().getTime()).withIssueDate(input.getCreatedAt().getTime()).build();
        return licenseCreator.signLicense(license, input.getLicensePassword().toCharArray());
    }

    public LicenseResponse generate(LicenseGeneratorInput input) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SignedLicense signedLicense = this.generateSignedLicense(input);
        return new LicenseResponse(LicenseSerializationUtilities.serialize((SignedLicense)signedLicense));
    }
}

