/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.service;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;
import org.gluu.oxd.licenser.server.ldap.LdapStructure;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseIdService {
    private static final Logger LOG = LoggerFactory.getLogger(LicenseIdService.class);
    @Inject
    PersistenceEntryManager ldapEntryManager;
    @Inject
    Configuration conf;
    @Inject
    LdapStructure ldapStructure;

    public List<LdapLicenseId> getAll() {
        try {
            Filter filter = Filter.createPresenceFilter((String)"licenseId");
            List entries = this.ldapEntryManager.findEntries(this.ldapStructure.getLicenseIdBaseDn(), LdapLicenseId.class, filter);
            this.patchList(entries);
            return entries;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public List<LdapLicenseId> getByCryptDn(String cryptDn) {
        try {
            Filter filter = Filter.createEqualityFilter((String)"oxLicenseCrypt", (Object)cryptDn);
            List entries = this.ldapEntryManager.findEntries(this.ldapStructure.getLicenseIdBaseDn(), LdapLicenseId.class, filter);
            this.patchList(entries);
            return entries;
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void patchList(List<LdapLicenseId> entries) {
        if (entries != null) {
            for (LdapLicenseId entry : entries) {
                this.patchEntry(entry);
            }
        }
    }

    private void patchEntry(LdapLicenseId entry) {
        try {
            if (!Strings.isNullOrEmpty((String)entry.getMetadata())) {
                entry.setMetadataAsObject((LicenseMetadata)Jackson.createJsonMapper().readValue(entry.getMetadata(), LicenseMetadata.class));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public LdapLicenseId get(String dn) {
        return (LdapLicenseId)this.ldapEntryManager.find(LdapLicenseId.class, (Object)dn);
    }

    public LdapLicenseId getById(String licenseId) {
        return (LdapLicenseId)this.ldapEntryManager.find(LdapLicenseId.class, (Object)this.dn(licenseId));
    }

    public void merge(LdapLicenseId entity) {
        try {
            this.ldapEntryManager.merge((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void save(LdapLicenseId entity) {
        try {
            this.setDnIfEmpty(entity);
            this.ldapEntryManager.persist((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void setDnIfEmpty(LdapLicenseId entity) {
        if (Strings.isNullOrEmpty((String)entity.getDn())) {
            String id = Strings.isNullOrEmpty((String)entity.getLicenseId()) ? this.generateLicenseId() : entity.getLicenseId();
            entity.setLicenseId(id);
            entity.setDn(this.dn(id));
        }
    }

    public String dn(String licenseId) {
        return String.format("licenseId=%s,%s", licenseId, this.ldapStructure.getLicenseIdBaseDn());
    }

    public void removeWithSubtreeByLicenseId(String licenseId) {
        try {
            this.ldapEntryManager.removeRecursively(this.dn(licenseId));
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void removeWithSubtreeByDn(String dn) {
        try {
            this.ldapEntryManager.removeRecursively(dn);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(LdapLicenseId entity) {
        try {
            this.ldapEntryManager.remove((Object)entity);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    public void remove(String licenseId) {
        this.remove(this.getById(licenseId));
    }

    private String generateLicenseId() {
        return UUID.randomUUID().toString();
    }

    public LdapLicenseId generate() {
        LdapLicenseId id = new LdapLicenseId();
        this.setDnIfEmpty(id);
        return id;
    }

    public LdapLicenseId generate(String cryptDN, LicenseMetadata metadata) {
        LdapLicenseId entity = this.generate();
        entity.setLicenseCryptDN(cryptDN);
        entity.setMetadata(Jackson.asJsonSilently((Object)metadata));
        entity.setMetadataAsObject(metadata);
        return entity;
    }

    public List<LdapLicenseId> generateLicenseIdsWithPersistence(int count, LdapLicenseCrypt licenseCrypt, LicenseMetadata metadata) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            LdapLicenseId entity = this.generate(licenseCrypt.getDn(), metadata);
            this.save(entity);
            result.add(entity);
        }
        return result;
    }
}

