package org.gluu.oxd.licenser.server.ldap;

import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 23/09/2014
 */

@DataEntry
@ObjectClass(values = {"top", "oxLicenseConfiguration"})
public class Conf {
    @DN
    private String dn;
    @AttributeName(name = "oxLicenseConf")
    private String conf;

    public String getConf() {
        return conf;
    }

    public void setConf(String p_conf) {
        conf = p_conf;
    }

    public String getDn() {
        return dn;
    }

    public void setDn(String p_dn) {
        dn = p_dn;
    }

    @Override
    public String toString() {
        final StringBuilder sb = new StringBuilder();
        sb.append("Conf");
        sb.append("{conf='").append(conf).append('\'');
        sb.append(", dn='").append(dn).append('\'');
        sb.append('}');
        return sb.toString();
    }
}
