package org.gluu.oxd.licenser.server.stat;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import org.gluu.oxd.license.client.js.event.LdapClientEvent;
import org.gluu.oxd.licenser.server.Utils;

import java.util.Map;
import java.util.Set;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 05/07/2017
 */

public class MacKey {

    private final String dateString;
    private final String macAddress;

    public MacKey(LdapClientEvent stat) {
        this.dateString = Utils.yearAndMonthAndDayOfMonth(stat.getCreationDate());
        this.macAddress = stat.getMacAddress();
    }

    public String getDateString() {
        return dateString;
    }

    public String getMacAddress() {
        return macAddress;
    }

    public static Map<String, Integer> countMap(Set<MacKey> value) {
        Map<String, Integer> map = Maps.newHashMap();
        for (MacKey v : value) {
            if (Strings.isNullOrEmpty(v.getMacAddress())) {
                continue;
            }

            Integer counter = map.get(v.getMacAddress());
            if (counter == null) {
                map.put(v.getMacAddress(), 1);
            } else {
                counter++;
                map.put(v.getMacAddress(), counter);
            }
        }
        return map;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        MacKey macKey = (MacKey) o;

        return !(dateString != null ? !dateString.equals(macKey.dateString) : macKey.dateString != null) && !(macAddress != null ? !macAddress.equals(macKey.macAddress) : macKey.macAddress != null);

    }

    @Override
    public int hashCode() {
        int result = dateString != null ? dateString.hashCode() : 0;
        result = 31 * result + (macAddress != null ? macAddress.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "MacKey{" +
                "dateString='" + dateString + '\'' +
                ", macAddress='" + macAddress + '\'' +
                '}';
    }
}
