/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.ws;

import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.ext.Provider;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.gluu.oxd.license.client.Jackson;
import org.gluu.oxd.licenser.server.conf.ConfigurationFactory;
import org.gluu.oxd.licenser.server.ws.PathPatcher;
import org.gluu.oxd.rs.protect.RsProtector;
import org.gluu.oxd.rs.protect.RsResource;
import org.gluu.oxd.rs.protect.StaticStorage;
import org.gluu.oxd.rs.protect.resteasy.Configuration;
import org.gluu.oxd.rs.protect.resteasy.ObtainPatProvider;
import org.gluu.oxd.rs.protect.resteasy.PatProvider;
import org.gluu.oxd.rs.protect.resteasy.ResourceRegistrar;
import org.gluu.oxd.rs.protect.resteasy.RptPreProcessInterceptor;
import org.gluu.oxd.rs.protect.resteasy.ServiceProvider;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ServerResponse;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.interception.PreProcessInterceptor;

@Provider
@ServerInterceptor
public class UmaProtector
implements PreProcessInterceptor {
    private static final Logger LOG = Logger.getLogger(UmaProtector.class);
    private static volatile boolean initialized = false;
    private static volatile boolean failedToInitialize = false;
    private static final String UGLY_HARDCODE = "ugly_hardcode_gerald_please_fix_rpt";
    private RptPreProcessInterceptor interceptor;
    private org.gluu.oxd.license.client.js.Configuration conf;

    @Inject
    public UmaProtector(org.gluu.oxd.license.client.js.Configuration conf) {
        try {
            this.conf = conf;
            LOG.info((Object)("Configuration : " + conf));
            this.initIfNeeded();
            this.interceptor = new RptPreProcessInterceptor((ResourceRegistrar)StaticStorage.get(ResourceRegistrar.class)){

                public String getPath(HttpRequest request) {
                    return PathPatcher.patchPath(super.getPath(request));
                }
            };
            LOG.info((Object)"UMA Protector started successfully.");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to initialize UMA Protector. " + e.getMessage()), (Throwable)e);
            failedToInitialize = true;
        }
    }

    private void initIfNeeded() {
        if (initialized) {
            return;
        }
        this.init();
        initialized = true;
    }

    private void init() {
        try {
            Collection<RsResource> values = this.resources();
            if (values.isEmpty()) {
                throw new RuntimeException("Failed to load UMA protection_document.");
            }
            LOG.info((Object)("Protection configuration: " + Jackson.asJsonSilently(values)));
            ServiceProvider serviceProvider = new ServiceProvider(this.conf.getOpHost(), true);
            Configuration umaLibConf = new Configuration();
            umaLibConf.setOpHost(this.conf.getOpHost());
            umaLibConf.setTrustAll(true);
            umaLibConf.setUmaPatClientId(this.conf.getUmaPatClientId());
            umaLibConf.setUmaPatClientSecret(this.conf.getUmaPatClientSecret());
            ObtainPatProvider patProvider = new ObtainPatProvider(serviceProvider, umaLibConf);
            ResourceRegistrar resourceRegistrar = new ResourceRegistrar((PatProvider)patProvider, serviceProvider);
            resourceRegistrar.register(values);
            LOG.info((Object)("Resources are registered at AS: " + umaLibConf));
            StaticStorage.put(PatProvider.class, (Object)patProvider);
            StaticStorage.put(ResourceRegistrar.class, (Object)resourceRegistrar);
            LOG.info((Object)"Resource Server started successfully.");
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to initialize UMA Protector. " + e.getMessage()), (Throwable)e);
            failedToInitialize = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RsResource> resources() {
        FileInputStream stream = null;
        try {
            LOG.info((Object)("UMA protect file location: " + ConfigurationFactory.UMA_PROTECT_FILE_LOCATION));
            File configFile = new File(ConfigurationFactory.UMA_PROTECT_FILE_LOCATION);
            if (configFile.exists()) {
                stream = new FileInputStream(configFile);
            } else {
                LOG.error((Object)("No configuration file. Fail to start! Location: " + ConfigurationFactory.UMA_PROTECT_FILE_LOCATION));
            }
            Collection<RsResource> collection = RsProtector.instance((InputStream)stream).getResourceMap().values();
            IOUtils.closeQuietly((InputStream)stream);
            return collection;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            List<RsResource> list = Collections.emptyList();
            return list;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    public ServerResponse preProcess(HttpRequest request, ResourceMethodInvoker invoker) throws Failure, WebApplicationException {
        if (failedToInitialize) {
            LOG.error((Object)"UMA Protector failed to initialize.");
            return null;
        }
        String rpt = RptPreProcessInterceptor.getRpt((HttpHeaders)request.getHttpHeaders());
        if (UGLY_HARDCODE.equalsIgnoreCase(rpt)) {
            LOG.error((Object)"HARDCODE : Gerald, please fix ecommerce !");
            return null;
        }
        return this.interceptor.preProcess(request, invoker);
    }
}

