/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.licenser.server.conf;

import java.io.File;
import org.gluu.util.properties.FileConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationFactory.class);
    private static final String BASE_DIR = System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : "";
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    public static final String CONFIG_FILE_NAME = "oxLicense-config.json";
    public static final String LDAP_CONFIG_FILE_NAME = "oxLicense-ldap.properties";
    public static final String PROTECTION_CONFIGURATION_FILE_NAME = "oxLicense-rs-protect.json";
    public static final String BASE_PROPERTIES_FILE = "oxLicense.properties";
    public static final String CONFIG_FILE_LOCATION = DIR + "oxLicense-config.json";
    public static final String LDAP_CONFIG_FILE_LOCATION = DIR + "oxLicense-ldap.properties";
    public static final String UMA_PROTECT_FILE_LOCATION = DIR + "oxLicense-rs-protect.json";
    public static final String BASE_CONFIG_FILE_LOCATION = DIR + "oxLicense.properties";

    private ConfigurationFactory() {
    }

    public static FileConfiguration getLdapConfiguration() {
        return LdapConfHolder.CONF;
    }

    private static class LdapConfHolder {
        private static final FileConfiguration CONF = LdapConfHolder.createLdapConfiguration();

        private LdapConfHolder() {
        }

        private static FileConfiguration createLdapConfiguration() {
            LOG.info("LDAP configuration file location: {}", (Object)LDAP_CONFIG_FILE_LOCATION);
            return new FileConfiguration(LDAP_CONFIG_FILE_LOCATION);
        }
    }
}

