package org.gluu.oxd.license.admin.client.service;

import com.google.gwt.user.client.rpc.AsyncCallback;
import org.gluu.oxd.license.admin.shared.IdTokenValidationResult;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;

import java.util.Collection;
import java.util.List;

public interface AdminServiceAsync {

    void save(String idToken, LdapLicenseCrypt customer, AsyncCallback<Void> async);

    void save(String idToken, LdapLicenseId entity, AsyncCallback<Void> async);

    void generate(String idToken, AsyncCallback<LdapLicenseCrypt> async);

    void getAllLicenseCryptObjects(String idToken, AsyncCallback<List<LdapLicenseCrypt>> async);

    void remove(String idToken, LdapLicenseCrypt entity, AsyncCallback<Void> async);

    void generateLicenseIds(String idToken, int count, LdapLicenseCrypt licenseCrypt, LicenseMetadata metadata, AsyncCallback<List<LdapLicenseId>> async);

    void loadLicenseIdsByCrypt(String idToken, LdapLicenseCrypt licenseCrypt, AsyncCallback<List<LdapLicenseId>> async);

    void getLicenseCrypt(String idToken, String dn, AsyncCallback<LdapLicenseCrypt> async);

    void remove(String idToken, Collection<LdapLicenseId> entities, AsyncCallback<Void> async);

    void getConfiguration(String idToken, AsyncCallback<Configuration> async);

    void hasAccess(String idToken, AsyncCallback<IdTokenValidationResult> async);

    void getLicenseId(String idToken, String licenseId, AsyncCallback<LdapLicenseId> async);

    void isGenerationApiProtected(String idToken, AsyncCallback<Boolean> async);
}
