package org.gluu.oxd.license.admin.client.service;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import org.gluu.oxd.license.admin.shared.IdTokenValidationResult;
import org.gluu.oxd.license.client.js.Configuration;
import org.gluu.oxd.license.client.js.LdapLicenseCrypt;
import org.gluu.oxd.license.client.js.LdapLicenseId;
import org.gluu.oxd.license.client.js.LicenseMetadata;

import java.util.Collection;
import java.util.List;

/**
 * @author Yuriy Zabrovarnyy
 * @version 0.9, 23/09/2014
 */

@RemoteServiceRelativePath("adminService.rpc")
public interface AdminService extends RemoteService {

    public Configuration getConfiguration(String idToken);

    public List<LdapLicenseCrypt> getAllLicenseCryptObjects(String idToken);

    public IdTokenValidationResult hasAccess(String idToken);

    public void save(String idToken, LdapLicenseCrypt entity);

    public void remove(String idToken, LdapLicenseCrypt entity);

    public void remove(String idToken, Collection<LdapLicenseId> entities);

    public LdapLicenseCrypt generate(String idToken);

    public List<LdapLicenseId> generateLicenseIds(String idToken, int count, LdapLicenseCrypt licenseCrypt, LicenseMetadata metadata);

    List<LdapLicenseId> loadLicenseIdsByCrypt(String idToken, LdapLicenseCrypt licenseCrypt);

    public LdapLicenseCrypt getLicenseCrypt(String idToken, String dn);

    void save(String idToken, LdapLicenseId entity);

    LdapLicenseId getLicenseId(String idToken, String licenseId);

    boolean isGenerationApiProtected(String idToken);
}
