/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxeleven.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.gluu.oxeleven.client.BaseRequest;
import org.gluu.oxeleven.client.BaseResponse;
import org.jboss.logging.Logger;

public abstract class BaseClient<T extends BaseRequest, V extends BaseResponse> {
    private static final Logger LOG = Logger.getLogger(BaseClient.class);
    protected String url;
    protected BaseRequest request;
    protected BaseResponse response;
    protected WebTarget webTarget = null;
    protected Form requestForm = new Form();
    protected Response clientResponse;

    public BaseClient(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    protected void addRequestParam(String key, String value) {
        if (!Strings.isNullOrEmpty((String)key) && !Strings.isNullOrEmpty((String)value)) {
            if ("POST".equals(this.request.getHttpMethod())) {
                this.requestForm.param(key, value);
            } else {
                this.webTarget = this.webTarget.queryParam(key, new Object[]{value});
            }
        }
    }

    protected void addRequestParam(String key, Long value) {
        if (!Strings.isNullOrEmpty((String)key) && value != null) {
            if ("POST".equals(this.request.getHttpMethod())) {
                this.requestForm.param(key, value.toString());
            } else {
                this.webTarget = this.webTarget.queryParam(key, new Object[]{value});
            }
        }
    }

    protected void addRequestParam(String key, String[] value) {
        if (!Strings.isNullOrEmpty((String)key) && value != null) {
            if ("POST".equals(this.request.getHttpMethod())) {
                this.requestForm.param(key, Arrays.toString(value));
            } else {
                this.webTarget = this.webTarget.queryParam(key, (Object[])value);
            }
        }
    }

    public abstract T getRequest();

    public abstract void setRequest(T var1);

    public abstract V getResponse();

    public abstract void setResponse(V var1);

    public abstract V exec() throws Exception;

    public String getRequestAsString() {
        StringBuilder sb = new StringBuilder();
        try {
            URL theUrl = new URL(this.url);
            if (this.getHttpMethod().equals("POST")) {
                sb.append("POST").append(" ").append(theUrl.getPath()).append(" HTTP/1.1");
                if (!Strings.isNullOrEmpty((String)this.request.getContentType())) {
                    sb.append("\n");
                    sb.append("Content-Type: ").append(this.request.getContentType());
                }
                if (!Strings.isNullOrEmpty((String)this.request.getMediaType())) {
                    sb.append("\n");
                    sb.append("Accept: ").append(this.request.getMediaType());
                }
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                String accessToken = this.request.getAccessToken();
                if (!Strings.isNullOrEmpty((String)accessToken)) {
                    sb.append("\n");
                    sb.append("Authorization: Bearer ").append(accessToken);
                }
                sb.append("\n");
                sb.append("\n");
                sb.append(this.request.getQueryString());
            } else if (this.getHttpMethod().equals("GET")) {
                sb.append("GET ").append(theUrl.getPath());
                if (!Strings.isNullOrEmpty((String)this.request.getQueryString())) {
                    sb.append("?").append(this.request.getQueryString());
                }
                sb.append(" HTTP/1.1");
                sb.append("\n");
                sb.append("Host: ").append(theUrl.getHost());
                String accessToken = this.request.getAccessToken();
                sb.append("\n");
                sb.append("Authorization: Bearer ").append(accessToken);
            }
        }
        catch (MalformedURLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return sb.toString();
    }

    public String getResponseAsString() {
        StringBuilder sb = new StringBuilder();
        if (this.response != null) {
            sb.append("HTTP/1.1 ").append(this.response.getStatus());
            if (this.response.getHeaders() != null) {
                for (String key : this.response.getHeaders().keySet()) {
                    sb.append("\n").append(key).append(": ").append(((List)this.response.getHeaders().get((Object)key)).get(0));
                }
            }
            if (this.response.getEntity() != null) {
                sb.append("\n");
                sb.append("\n");
                sb.append(this.response.getEntity());
            }
        }
        return sb.toString();
    }

    public abstract String getHttpMethod();

    public static String toPrettyJson(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
    }
}

