/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jackson2 {
    private static final Logger LOG = LoggerFactory.getLogger(Jackson2.class);

    private Jackson2() {
    }

    public static ObjectMapper createJsonMapper() {
        return JacksonMapperHolder.MAPPER;
    }

    public static String asJson(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson2.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        return mapper.writeValueAsString(p_object);
    }

    public static ObjectMapper createRpMapper() {
        return Jackson2.createJsonMapperWithoutEmptyAttributes();
    }

    public static ObjectMapper createJsonMapperWithoutEmptyAttributes() {
        ObjectMapper mapper = Jackson2.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        return mapper;
    }

    public static String serializeWithoutNulls(Object p_object) throws IOException {
        ObjectMapper mapper = Jackson2.createRpMapper();
        return mapper.writeValueAsString(p_object);
    }

    public static String asJsonSilently(Object p_object) {
        try {
            ObjectMapper mapper = Jackson2.createJsonMapper().configure(SerializationFeature.WRAP_ROOT_VALUE, false);
            return mapper.writeValueAsString(p_object);
        }
        catch (Exception e) {
            LOG.error("Failed to serialize object into json.", (Throwable)e);
            return "";
        }
    }

    public static JsonNode asOldNode(JsonNode node) throws IOException {
        return Jackson2.createJsonMapper().readTree(Jackson2.asJsonSilently(node));
    }

    private static class JacksonMapperHolder {
        private static final ObjectMapper MAPPER = JacksonMapperHolder.jsonMapper();

        private JacksonMapperHolder() {
        }

        public static ObjectMapper jsonMapper() {
            JacksonAnnotationIntrospector jackson = new JacksonAnnotationIntrospector();
            ObjectMapper mapper = new ObjectMapper();
            DeserializationConfig deserializationConfig = (DeserializationConfig)mapper.getDeserializationConfig().with((AnnotationIntrospector)jackson);
            SerializationConfig serializationConfig = (SerializationConfig)mapper.getSerializationConfig().with((AnnotationIntrospector)jackson);
            if (deserializationConfig == null || serializationConfig != null) {
                // empty if block
            }
            return mapper;
        }
    }
}

