/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Calendar;
import org.gluu.oxd.common.ExpiredObjectType;
import org.gluu.oxd.common.Jackson2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiredObject {
    private String key;
    private String value;
    private Long createdAt;
    private Long expiredAt;
    private ExpiredObjectType type;
    private static final Logger LOG = LoggerFactory.getLogger(ExpiredObject.class);

    public ExpiredObject() {
    }

    public ExpiredObject(String key, ExpiredObjectType expiredObjectType, int expiredObjectExpirationInMins) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Expired Object contains blank or null value. Please specify valid Expired Object.");
        Calendar cal = Calendar.getInstance();
        this.key = key;
        this.type = expiredObjectType;
        this.createdAt = cal.getTimeInMillis();
        cal.add(12, expiredObjectExpirationInMins);
        this.expiredAt = cal.getTimeInMillis();
        try {
            this.value = Jackson2.createJsonMapperWithoutEmptyAttributes().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error in assigning json value to ExpiredObject value attribute.", (Throwable)e);
        }
    }

    public ExpiredObject(String key, ExpiredObjectType expiredObjectType, Long createdAt, Long expiredAt) {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)key) ? 1 : 0) != 0, (Object)"Expired Object contains blank or null value. Please specify valid Expired Object.");
        Calendar cal = Calendar.getInstance();
        this.key = key;
        this.type = expiredObjectType;
        this.createdAt = createdAt;
        this.expiredAt = expiredAt;
        try {
            this.value = Jackson2.createJsonMapperWithoutEmptyAttributes().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error in assigning json value to ExpiredObject value attribute.", (Throwable)e);
        }
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    public Long getExpiredAt() {
        return this.expiredAt;
    }

    public void setExpiredAt(Long expiredAt) {
        this.expiredAt = expiredAt;
    }

    public ExpiredObjectType getType() {
        return this.type;
    }

    public void setType(ExpiredObjectType type) {
        this.type = type;
    }

    public String toString() {
        return "ExpiredObject{key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", createdAt=" + this.createdAt + ", expiredAt=" + this.expiredAt + ", type=" + this.type.getValue() + '}';
    }
}

