/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.oxd.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.gluu.oxd.common.Command;
import org.gluu.oxd.common.CommandType;
import org.gluu.oxd.common.ErrorResponse;
import org.gluu.oxd.common.ErrorResponseCode;
import org.gluu.oxd.common.Jackson2;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JsonTest {
    @Test
    public void testCommandType() throws IOException {
        String json = Jackson2.asJson((Object)CommandType.GET_AUTHORIZATION_URL);
        Assert.assertEquals((String)json, (String)"\"obtain_pat\"");
        CommandType obtainPat = (CommandType)Jackson2.createJsonMapper().readValue(json, CommandType.class);
        Assert.assertNotNull((Object)obtainPat);
    }

    @Test
    public void testCommand() throws IOException {
        Command c = new Command();
        c.setCommandType(CommandType.GET_USER_INFO);
        c.setParams((JsonNode)JsonNodeFactory.instance.textNode("myParams"));
        String cJson = Jackson2.asJson((Object)c);
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)cJson));
        String json = "{\"command\":\"register_client\",\"params\": {\"discovery_url\":\"<discovery url>\",\n        \"redirect_url\":\"<redirect url>\",\n        \"client_name\":\"<client name>\"\n    }\n}";
        Command command = (Command)Jackson2.createJsonMapper().readValue("{\"command\":\"register_client\",\"params\": {\"discovery_url\":\"<discovery url>\",\n        \"redirect_url\":\"<redirect url>\",\n        \"client_name\":\"<client name>\"\n    }\n}", Command.class);
        Assert.assertNotNull((Object)command);
    }

    @Test
    public void testErrorResponseJson() throws IOException {
        String json = Jackson2.asJson((Object)new ErrorResponse(ErrorResponseCode.INTERNAL_ERROR_UNKNOWN));
        Assert.assertTrue((boolean)StringUtils.isNotBlank((String)json));
    }
}

