/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.util.security;

import java.util.Properties;
import org.gluu.util.StringHelper;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesDecrypter {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesDecrypter.class);
    public static final String BIND_PASSWORD = "bindPassword";
    public static final String TRUST_STORE_PIN = "ssl.trustStorePin";

    private PropertiesDecrypter() {
    }

    public static Properties decryptProperties(Properties properties, String encryptionKey) {
        try {
            return PropertiesDecrypter.decryptProperties(StringEncrypter.defaultInstance(), properties, encryptionKey);
        }
        catch (StringEncrypter.EncryptionException ex) {
            LOG.error(String.format("Failed to decript '%s' property", BIND_PASSWORD), (Throwable)ex);
            return properties;
        }
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties) {
        return PropertiesDecrypter.decryptProperties(stringEncrypter, properties, null);
    }

    public static Properties decryptProperties(StringEncrypter stringEncrypter, Properties properties, String encryptionKey) {
        if (properties == null) {
            return properties;
        }
        Properties clondedProperties = (Properties)properties.clone();
        PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, BIND_PASSWORD, true);
        PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, TRUST_STORE_PIN, true);
        return clondedProperties;
    }

    public static Properties decryptAllProperties(StringEncrypter stringEncrypter, Properties properties) {
        return PropertiesDecrypter.decryptAllProperties(stringEncrypter, properties, null);
    }

    public static Properties decryptAllProperties(StringEncrypter stringEncrypter, Properties properties, String encryptionKey) {
        if (properties == null) {
            return properties;
        }
        Properties clondedProperties = (Properties)properties.clone();
        for (Object key : clondedProperties.keySet()) {
            String propertyName = (String)key;
            PropertiesDecrypter.decriptProperty(stringEncrypter, clondedProperties, encryptionKey, propertyName, true);
        }
        return clondedProperties;
    }

    private static void decriptProperty(StringEncrypter stringEncrypter, Properties properties, String encryptionKey, String propertyName, boolean silent) {
        String propertyValue = properties.getProperty(propertyName);
        if (StringHelper.isEmpty(propertyValue)) {
            return;
        }
        try {
            String decryptedProperty = StringHelper.isEmpty(encryptionKey) ? stringEncrypter.decrypt(propertyValue, silent) : stringEncrypter.decrypt(propertyValue, encryptionKey, silent);
            if (StringHelper.isEmpty(decryptedProperty)) {
                decryptedProperty = propertyValue;
            }
            properties.put(propertyName, decryptedProperty);
        }
        catch (StringEncrypter.EncryptionException ex) {
            LOG.error(String.format("Failed to decript '%s' property", propertyName), (Throwable)ex);
        }
    }

    public static String decryptProperty(String encryptedValue, boolean returnSource, String encryptionKey) {
        String resultValue;
        block3: {
            if (encryptedValue == null) {
                return encryptedValue;
            }
            resultValue = returnSource ? encryptedValue : null;
            try {
                resultValue = StringEncrypter.defaultInstance().decrypt(encryptedValue, encryptionKey);
            }
            catch (Exception ex) {
                if (returnSource) break block3;
                LOG.error(String.format("Failed to decrypt value: '%s'", encryptedValue, ex));
            }
        }
        return resultValue;
    }
}

