/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.conf.service;

import java.io.File;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.gluu.conf.model.AppConfiguration;
import org.gluu.conf.model.AppConfigurationEntry;
import org.gluu.conf.model.SharedConfigurationEntry;
import org.gluu.orm.util.properties.FileConfiguration;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.PersistenceEntryManagerFactory;
import org.gluu.persist.exception.BasePersistenceException;
import org.gluu.persist.model.PersistenceConfiguration;
import org.gluu.persist.service.PersistanceFactoryService;
import org.gluu.persist.service.StandalonePersistanceFactoryService;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.InMemoryConfiguration;
import org.gluu.util.StringHelper;
import org.gluu.util.exception.ConfigurationException;
import org.gluu.util.security.PropertiesDecrypter;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationFactory<C extends AppConfiguration, L extends AppConfigurationEntry> {
    private final Logger LOG = LoggerFactory.getLogger(ConfigurationFactory.class);
    public static final String BASE_DIR = System.getProperty("gluu.base") != null ? System.getProperty("gluu.base") : (System.getProperty("catalina.base") != null && System.getProperty("catalina.base.ignore") == null ? System.getProperty("catalina.base") : (System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : (System.getProperty("jboss.home.dir") != null ? System.getProperty("jboss.home.dir") : null)));
    public static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String BASE_PROPERTIES_FILE = DIR + "gluu.properties";
    public static final String DEFAULT_PROPERTIES_FILE = DIR + "openid.properties";
    private static final String SALT_FILE_NAME = "salt";
    private static final String SHARED_CONFIGURATION_DN = "ou=configuration,o=gluu";
    private String confDir;
    private String saltFilePath;
    private FileConfiguration baseConfiguration;
    private C appConfiguration;
    private PersistanceFactoryService persistanceFactoryService;
    private PersistenceConfiguration persistenceConfiguration;
    private String cryptoConfigurationSalt;
    private StringEncrypter stringEncrypter;
    private PersistenceEntryManager persistenceEntryManager;
    private CacheConfiguration cacheConfiguration;
    private long baseConfigurationFileLastModifiedTime;
    private boolean loaded = false;
    private long loadedRevision = -1L;
    private AtomicBoolean isActive = new AtomicBoolean(true);

    protected ConfigurationFactory() {
        try {
            this.create();
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void create() {
        this.persistanceFactoryService = new StandalonePersistanceFactoryService();
        this.persistenceConfiguration = this.persistanceFactoryService.loadPersistenceConfiguration(this.getDefaultConfigurationFileName());
        this.baseConfiguration = this.loadBaseConfiguration();
        this.confDir = this.confDir();
        this.saltFilePath = this.confDir + SALT_FILE_NAME;
        this.cryptoConfigurationSalt = this.loadCryptoConfigurationSalt();
        this.stringEncrypter = this.createStringEncrypter();
        this.persistenceEntryManager = this.createPersistenceEntryManager();
        if (!this.createFromDb()) {
            this.LOG.error("Failed to load configuration from DB. Please fix it!!!.");
            throw new ConfigurationException("Failed to load configuration from DB.");
        }
        this.loaded = true;
        this.LOG.info("Configuration loaded successfully.");
        this.cacheConfiguration = this.loadCacheConfiguration();
    }

    public void destroy() {
        if (this.persistenceEntryManager != null) {
            this.destroyPersistenceEntryManager(this.persistenceEntryManager);
        }
    }

    private FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                this.LOG.error("Failed to load configuration from {}", (Object)fileName, (Object)ex);
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    private FileConfiguration loadBaseConfiguration() {
        FileConfiguration fileConfiguration = this.createFileConfiguration(BASE_PROPERTIES_FILE, true);
        return fileConfiguration;
    }

    private String loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = new FileConfiguration(this.saltFilePath);
            return cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            this.LOG.error("Failed to load configuration from {}", (Object)this.saltFilePath, (Object)ex);
            throw new ConfigurationException("Failed to load configuration from " + this.saltFilePath, (Throwable)ex);
        }
    }

    private CacheConfiguration loadCacheConfiguration() {
        SharedConfigurationEntry sharedConfigurationEntry = (SharedConfigurationEntry)this.persistenceEntryManager.find(SharedConfigurationEntry.class, (Object)SHARED_CONFIGURATION_DN);
        if (sharedConfigurationEntry == null) {
            this.LOG.error("Failed to load share configuration from DB. Please fix it!!!.");
            throw new ConfigurationException("Failed to load shared configuration from DB.");
        }
        CacheConfiguration cacheConfiguration = sharedConfigurationEntry.getCacheConfiguration();
        if (cacheConfiguration == null || cacheConfiguration.getCacheProviderType() == null) {
            this.LOG.error("Failed to read cache configuration from DB. Please check configuration oxCacheConfiguration attribute that must contain cache configuration JSON represented by CacheConfiguration.class. Shared configuration DN: ou=configuration,o=gluu");
            this.LOG.info("Creating fallback IN-MEMORY cache configuration ... ");
            cacheConfiguration = new CacheConfiguration();
            cacheConfiguration.setInMemoryConfiguration(new InMemoryConfiguration());
            this.LOG.info("IN-MEMORY cache configuration is created.");
        }
        this.LOG.info("Cache configuration: " + cacheConfiguration);
        return cacheConfiguration;
    }

    private String confDir() {
        String confDir = this.getPersistenceConfiguration().getString("confDir");
        if (StringUtils.isNotBlank((String)confDir)) {
            return confDir;
        }
        return DIR;
    }

    private boolean createFromDb() {
        this.LOG.info("Loading configuration from '{}' DB...", (Object)this.baseConfiguration.getString("persistence.type"));
        try {
            L persistenceConf = this.loadConfigurationFromDb(new String[0]);
            this.loadedRevision = ((AppConfigurationEntry)persistenceConf).getRevision();
            if (persistenceConf != null) {
                this.appConfiguration = ((AppConfigurationEntry)persistenceConf).getApplication();
                return true;
            }
        }
        catch (Exception ex) {
            this.LOG.error(ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private L loadConfigurationFromDb(String ... returnAttributes) {
        try {
            String dn = this.baseConfiguration.getString(this.getApplicationConfigurationPropertyName());
            AppConfigurationEntry persistanceConf = (AppConfigurationEntry)this.persistenceEntryManager.find((Object)dn, this.getAppConfigurationType(), returnAttributes);
            return (L)persistanceConf;
        }
        catch (BasePersistenceException ex) {
            this.LOG.error(ex.getMessage());
            return null;
        }
    }

    protected Properties preparePersistanceProperties() {
        Properties decryptedConnectionProperties;
        FileConfiguration persistenceConfig = this.persistenceConfiguration.getConfiguration();
        Properties connectionProperties = persistenceConfig.getProperties();
        try {
            decryptedConnectionProperties = PropertiesDecrypter.decryptAllProperties((StringEncrypter)StringEncrypter.defaultInstance(), (Properties)connectionProperties, (String)this.cryptoConfigurationSalt);
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to decript configuration properties", (Throwable)ex);
        }
        return decryptedConnectionProperties;
    }

    private PersistenceEntryManager createPersistenceEntryManager() {
        Properties connectionProperties = this.preparePersistanceProperties();
        PersistenceEntryManagerFactory persistenceEntryManagerFactory = this.persistanceFactoryService.getPersistenceEntryManagerFactory(this.persistenceConfiguration);
        PersistenceEntryManager persistenceEntryManager = persistenceEntryManagerFactory.createEntryManager(connectionProperties);
        this.LOG.info("Created PersistenceEntryManager: {} with operation service: {}", new Object[]{persistenceEntryManager, persistenceEntryManager.getOperationService()});
        return persistenceEntryManager;
    }

    private void destroyPersistenceEntryManager(PersistenceEntryManager persistenceEntryManager) {
        boolean result = persistenceEntryManager.destroy();
        if (result) {
            this.LOG.debug("Destoyed PersistenceEntryManager: {}", (Object)persistenceEntryManager);
        } else {
            this.LOG.error("Failed to destoy PersistenceEntryManager: {}", (Object)persistenceEntryManager);
        }
    }

    private StringEncrypter createStringEncrypter() {
        String encodeSalt = this.cryptoConfigurationSalt;
        if (StringHelper.isEmpty((String)encodeSalt)) {
            throw new ConfigurationException("Encode salt isn't defined");
        }
        try {
            StringEncrypter stringEncrypter = StringEncrypter.instance((String)encodeSalt);
            return stringEncrypter;
        }
        catch (StringEncrypter.EncryptionException ex) {
            throw new ConfigurationException("Failed to create StringEncrypter instance");
        }
    }

    public StringEncrypter getStringEncrypter() {
        return this.stringEncrypter;
    }

    public FileConfiguration getPersistenceConfiguration() {
        return this.persistenceConfiguration.getConfiguration();
    }

    public FileConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    public String getCryptoConfigurationSalt() {
        return this.cryptoConfigurationSalt;
    }

    public PersistenceEntryManager getPersistenceEntryManager() {
        return this.persistenceEntryManager;
    }

    protected String getDefaultPersistanceConfigurationFileName() {
        return "gluu-ldap.properties";
    }

    public C getAppConfiguration() {
        return this.appConfiguration;
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.cacheConfiguration;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public long getLoadedRevision() {
        return this.loadedRevision;
    }

    protected abstract String getDefaultConfigurationFileName();

    protected abstract Class<L> getAppConfigurationType();

    protected abstract String getApplicationConfigurationPropertyName();
}

