/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.metric;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.time.DateUtils;
import org.gluu.model.ApplicationType;
import org.gluu.model.metric.MetricType;
import org.gluu.model.metric.counter.CounterMetricData;
import org.gluu.model.metric.counter.CounterMetricEntry;
import org.gluu.model.metric.ldap.MetricEntry;
import org.gluu.model.metric.timer.TimerMetricData;
import org.gluu.model.metric.timer.TimerMetricEntry;
import org.gluu.service.metric.MetricService;

public final class LdapEntryReporter
extends ScheduledReporter {
    private final Clock clock;
    private final MetricService metricService;
    private Date startTime;

    public static Builder forRegistry(MetricRegistry registry, MetricService metricService) {
        return new Builder(registry, metricService);
    }

    private LdapEntryReporter(MetricRegistry registry, Clock clock, TimeZone timeZone, TimeUnit rateUnit, TimeUnit durationUnit, MetricFilter filter, MetricService metricService) {
        super(registry, "reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
        this.metricService = metricService;
        this.startTime = new Date();
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        this.reportImpl(counters, timers);
    }

    private void reportImpl(SortedMap<String, Counter> counters, SortedMap<String, Timer> timers) {
        List<MetricEntry> result;
        if (!this.metricService.isMetricReporterEnabled()) {
            return;
        }
        Date currentRunTime = new Date(this.clock.getTime());
        ArrayList<MetricEntry> metricEntries = new ArrayList<MetricEntry>();
        if (counters != null && !counters.isEmpty()) {
            result = this.builCounterEntries(counters, this.metricService.getRegisteredMetricTypes());
            metricEntries.addAll(result);
        }
        if (timers != null && !timers.isEmpty()) {
            result = this.builTimerEntries(timers, this.metricService.getRegisteredMetricTypes());
            metricEntries.addAll(result);
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentRunTime);
        cal.add(14, -1);
        Date endTime = cal.getTime();
        Date creationTime = new Date();
        if (metricEntries.size() > 0) {
            this.addMandatoryAttributes(this.metricService, this.startTime, endTime, metricEntries, creationTime);
        }
        this.startTime = currentRunTime;
        this.metricService.add(metricEntries, creationTime);
    }

    private List<MetricEntry> builCounterEntries(SortedMap<String, Counter> counters, Set<MetricType> registeredMetricTypes) {
        ArrayList<MetricEntry> result = new ArrayList<MetricEntry>();
        HashSet<MetricType> currentRegisteredMetricTypes = new HashSet<MetricType>(registeredMetricTypes);
        for (MetricType metricType : currentRegisteredMetricTypes) {
            Counter counter = (Counter)counters.get(metricType.getValue());
            if (counter == null) continue;
            long count = counter.getCount();
            CounterMetricData counterMetricData = new CounterMetricData(count);
            CounterMetricEntry counterMetricEntry = new CounterMetricEntry();
            counterMetricEntry.setMetricData(counterMetricData);
            counterMetricEntry.setMetricType(metricType);
            result.add((MetricEntry)counterMetricEntry);
        }
        return result;
    }

    private List<MetricEntry> builTimerEntries(SortedMap<String, Timer> timers, Set<MetricType> registeredMetricTypes) {
        ArrayList<MetricEntry> result = new ArrayList<MetricEntry>();
        for (MetricType metricType : registeredMetricTypes) {
            Timer timer = (Timer)timers.get(metricType.getValue());
            if (timer == null) continue;
            Snapshot snapshot = timer.getSnapshot();
            TimerMetricData timerMetricData = new TimerMetricData(timer.getCount(), this.convertRate(timer.getMeanRate()), this.convertRate(timer.getOneMinuteRate()), this.convertRate(timer.getFiveMinuteRate()), this.convertRate(timer.getFifteenMinuteRate()), this.getRateUnit(), this.convertDuration(snapshot.getMin()), this.convertDuration(snapshot.getMax()), this.convertDuration(snapshot.getMean()), this.convertDuration(snapshot.getStdDev()), this.convertDuration(snapshot.getMedian()), this.convertDuration(snapshot.get75thPercentile()), this.convertDuration(snapshot.get95thPercentile()), this.convertDuration(snapshot.get98thPercentile()), this.convertDuration(snapshot.get99thPercentile()), this.convertDuration(snapshot.get999thPercentile()), this.getDurationUnit());
            TimerMetricEntry timerMetricEntry = new TimerMetricEntry();
            timerMetricEntry.setMetricData(timerMetricData);
            timerMetricEntry.setMetricType(metricType);
            result.add((MetricEntry)timerMetricEntry);
        }
        return result;
    }

    private void addMandatoryAttributes(MetricService metricService, Date startTime, Date endTime, List<MetricEntry> metricEntries, Date creationTime) {
        String nodeIndetifier = metricService.getNodeIndetifier();
        ApplicationType applicationType = metricService.getApplicationType();
        for (MetricEntry metricEntry : metricEntries) {
            String id = metricService.getUiqueIdentifier();
            String dn = metricService.buildDn(id, creationTime, applicationType);
            metricEntry.setId(id);
            metricEntry.setDn(dn);
            metricEntry.setApplicationType(applicationType);
            metricEntry.setNodeIndetifier(nodeIndetifier);
            metricEntry.setStartDate(startTime);
            metricEntry.setEndDate(endTime);
            metricEntry.setCreationDate(creationTime);
            metricEntry.setExpirationDate(DateUtils.addDays((Date)creationTime, (int)metricService.getEntryLifetimeInDays()));
            int ttl = (int)((metricEntry.getExpirationDate().getTime() - creationTime.getTime()) / 1000L);
            metricEntry.setTtl(Integer.valueOf(ttl));
        }
    }

    public static final class Builder {
        private final MetricRegistry registry;
        private Clock clock;
        private TimeZone timeZone;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private MetricFilter filter;
        private MetricService metricService;

        private Builder(MetricRegistry registry, MetricService metricService) {
            this.registry = registry;
            this.clock = Clock.defaultClock();
            this.timeZone = TimeZone.getDefault();
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.filter = MetricFilter.ALL;
            this.metricService = metricService;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public LdapEntryReporter build() {
            return new LdapEntryReporter(this.registry, this.clock, this.timeZone, this.rateUnit, this.durationUnit, this.filter, this.metricService);
        }
    }
}

