/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.external.context;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalScriptContext {
    private static final Logger log = LoggerFactory.getLogger(ExternalScriptContext.class);
    private final Map<String, Object> contextVariables = new HashMap<String, Object>();
    protected HttpServletRequest httpRequest;
    protected final HttpServletResponse httpResponse;

    public ExternalScriptContext(HttpServletRequest httpRequest) {
        this(httpRequest, null);
    }

    public ExternalScriptContext(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        ExternalContext extCtx;
        FacesContext facesContext;
        this.httpRequest = httpRequest;
        this.httpResponse = httpResponse;
        if (this.httpRequest == null && (facesContext = FacesContext.getCurrentInstance()) != null && (extCtx = facesContext.getExternalContext()) != null) {
            this.httpRequest = (HttpServletRequest)extCtx.getRequest();
        }
    }

    public Logger getLog() {
        return log;
    }

    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    public HttpServletResponse getHttpResponse() {
        return this.httpResponse;
    }

    public String getIpAddress() {
        return this.httpRequest != null ? this.httpRequest.getRemoteAddr() : "";
    }

    public Map<String, Object> getContextVariables() {
        return this.contextVariables;
    }
}

