/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ApplicationScoped
public class XmlService {
    private static final long serialVersionUID = -4805285557592935972L;
    @Inject
    private Logger log;

    public Document getXmlDocument(String xmlDocument) throws SAXException, IOException, ParserConfigurationException {
        return this.getXmlDocument(xmlDocument, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(String xmlDocument, boolean skipValidation) throws SAXException, IOException, ParserConfigurationException {
        InputStream is = IOUtils.toInputStream((String)xmlDocument, (Charset)Charset.forName("utf-8"));
        try {
            DocumentBuilderFactory fty = this.createDocumentBuilderFactory(skipValidation);
            Document document = fty.newDocumentBuilder().parse(is);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public Document getXmlDocument(byte[] xmlDocumentBytes) throws SAXException, IOException, ParserConfigurationException {
        return this.getXmlDocument(xmlDocumentBytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(byte[] xmlDocumentBytes, boolean skipValidation) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlDocumentBytes);
        try {
            DocumentBuilderFactory fty = this.createDocumentBuilderFactory(skipValidation);
            Document document = fty.newDocumentBuilder().parse(bis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public Document getXmlDocument(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(is);
    }

    public Document getXmlDocument(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(is);
    }

    public Document getXmlDocumentFromUri(String uri) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(uri);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        return this.createDocumentBuilderFactory(false);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory(boolean skipValidation) throws ParserConfigurationException {
        DocumentBuilderFactory fty = DocumentBuilderFactory.newInstance();
        if (skipValidation) {
            return fty;
        }
        fty.setNamespaceAware(true);
        fty.setXIncludeAware(false);
        fty.setExpandEntityReferences(false);
        fty.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        fty.setFeature("http://xml.org/sax/features/external-general-entities", false);
        fty.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return fty;
    }

    public String getNodeValue(Document xmlDocument, String xPathExpression, String attributeName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression formXPathExpression = xPath.compile(xPathExpression);
        if (StringHelper.isEmpty((String)attributeName)) {
            String nodeValue = (String)formXPathExpression.evaluate(xmlDocument, XPathConstants.STRING);
            return nodeValue;
        }
        Node node = (Node)formXPathExpression.evaluate(xmlDocument, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode == null) {
            if (node.getChildNodes().getLength() == 1 && (node = node.getFirstChild()).getNodeType() == 3) {
                return node.getNodeValue();
            }
            return null;
        }
        return attributeNode.getNodeValue();
    }
}

