/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model.security;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.gluu.model.security.Credentials;
import org.gluu.model.security.Group;
import org.gluu.model.security.Role;
import org.gluu.model.security.SimpleGroup;
import org.gluu.model.security.SimplePrincipal;
import org.gluu.model.security.event.Authenticated;
import org.slf4j.Logger;

@RequestScoped
@Named
@Alternative
@Priority(value=2010)
public class Identity
implements Serializable {
    private static final long serialVersionUID = 3751659008033189259L;
    public static final String EVENT_LOGIN_SUCCESSFUL = "org.jboss.seam.security.loginSuccessful";
    public static final String ROLES_GROUP = "Roles";
    @Inject
    private Logger log;
    @Inject
    private Credentials credentials;
    @Inject
    private Event<String> event;
    private Principal principal;
    private HashMap<String, Object> workingParameters;
    private Subject subject;

    @PostConstruct
    public void create() {
        this.subject = new Subject();
    }

    public boolean isLoggedIn() {
        return this.getPrincipal() != null;
    }

    public boolean tryLogin() {
        if (this.getPrincipal() == null && this.credentials.isSet()) {
            this.quietLogin();
        }
        return this.isLoggedIn();
    }

    public String login() {
        try {
            if (this.isLoggedIn()) {
                return "loggedIn";
            }
            this.authenticate();
            if (!this.isLoggedIn()) {
                throw new LoginException();
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Login successful for: " + this.credentials.getUsername());
            }
            this.event.select(new Annotation[]{Authenticated.Literal.INSTANCE}).fire((Object)EVENT_LOGIN_SUCCESSFUL);
            return "loggedIn";
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Login failed for: " + this.credentials.getUsername(), (Throwable)ex);
            }
            return null;
        }
    }

    public void quietLogin() {
        try {
            if (!this.isLoggedIn() && this.credentials.isSet()) {
                this.authenticate();
            }
        }
        catch (LoginException ex) {
            this.credentials.invalidate();
        }
    }

    public synchronized void authenticate() throws LoginException {
        if (!this.isLoggedIn() && !this.credentials.isInvalid()) {
            this.principal = new SimplePrincipal(this.credentials.getUsername());
            this.credentials.setPassword(null);
        }
    }

    public void acceptExternallyAuthenticatedPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void unAuthenticate() {
        this.principal = null;
        this.credentials.clear();
        this.subject = new Subject();
    }

    public void logout() {
        if (this.isLoggedIn()) {
            this.unAuthenticate();
        }
    }

    private synchronized void initWorkingParamaters() {
        if (this.workingParameters == null) {
            this.workingParameters = new HashMap();
        }
    }

    public HashMap<String, Object> getWorkingParameters() {
        this.initWorkingParamaters();
        return this.workingParameters;
    }

    public boolean isSetWorkingParameter(String name) {
        return this.getWorkingParameters().containsKey(name);
    }

    public Object getWorkingParameter(String name) {
        return this.getWorkingParameters().get(name);
    }

    public void setWorkingParameter(String name, Object value) {
        this.getWorkingParameters().put(name, value);
    }

    public boolean addRole(String role) {
        if (role == null || "".equals(role)) {
            return false;
        }
        if (!this.isLoggedIn()) {
            return false;
        }
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.addMember(new Role(role));
        }
        SimpleGroup roleGroup = new SimpleGroup(ROLES_GROUP);
        roleGroup.addMember(new Role(role));
        this.getSubject().getPrincipals().add(roleGroup);
        return true;
    }

    public boolean hasRole(String role) {
        this.tryLogin();
        for (Group sg : this.getSubject().getPrincipals(Group.class)) {
            if (!ROLES_GROUP.equals(sg.getName())) continue;
            return sg.isMember(new Role(role));
        }
        return false;
    }
}

