/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.logger;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.gluu.model.types.LoggingLayoutType;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.gluu.service.cdi.event.LoggerUpdateEvent;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

public abstract class LoggerService {
    private static final int DEFAULT_INTERVAL = 15;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    private AtomicBoolean isActive;

    @PostConstruct
    public void create() {
        this.isActive = new AtomicBoolean(false);
    }

    public void initTimer() {
        this.log.info("Initializing Logger Update Timer");
        int delay = 15;
        int interval = 15;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(15, 15), (Object)new LoggerUpdateEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void updateLoggerTimerEvent(@Observes @Scheduled LoggerUpdateEvent loggerUpdateEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating newly added logger configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateLoggerConfiguration() {
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel) || StringUtils.isEmpty((String)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        LoggingLayoutType loggingLayout = LoggingLayoutType.getByValue((String)this.getLoggingLayout().toUpperCase());
        this.updateAppendersAndLogLevel(loggingLayout, level);
    }

    public void updateLoggerSeverity(@Observes @ConfigurationUpdate Object appConfiguration) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerSeverityImpl();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating logger configuration after base configuration update", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void updateLoggerSeverity() {
        this.updateLoggerSeverityImpl();
    }

    private void updateLoggerSeverityImpl() {
        this.setDisableJdkLogger();
        if (this.setExternalLoggerConfig()) {
            return;
        }
        this.resetLoggerConfigLocation();
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel) || StringUtils.isEmpty((String)this.getLoggingLayout()) || StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        LoggingLayoutType loggingLayout = LoggingLayoutType.getByValue((String)this.getLoggingLayout().toUpperCase());
        this.log.info("Setting layout and loggers level to '{}`, `{}' after configuration update", (Object)loggingLayout, (Object)loggingLevel);
        this.updateAppendersAndLogLevel(loggingLayout, level);
    }

    private void setDisableJdkLogger() {
        if (this.isDisableJdkLogger()) {
            LogManager.getLogManager().reset();
            java.util.logging.Logger globalLogger = java.util.logging.Logger.getLogger("global");
            if (globalLogger != null) {
                globalLogger.setLevel(java.util.logging.Level.OFF);
            }
        }
    }

    private boolean setExternalLoggerConfig() {
        String externalLoggerConfiguration = this.getExternalLoggerConfiguration();
        this.log.info("External log configuration: {}", (Object)externalLoggerConfiguration);
        if (StringUtils.isEmpty((String)externalLoggerConfiguration)) {
            return false;
        }
        File log4jFile = new File(externalLoggerConfiguration);
        if (!log4jFile.exists()) {
            this.log.info("External log configuration does not exist.");
            return false;
        }
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        loggerContext.setConfigLocation(log4jFile.toURI());
        loggerContext.reconfigure();
        return true;
    }

    public void resetLoggerConfigLocation() {
        this.log.info("Reloading log4j2 configuration");
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        if (loggerContext.getConfigLocation() != null) {
            loggerContext.setConfigLocation(null);
        }
        loggerContext.reconfigure();
    }

    private void updateAppendersAndLogLevel(LoggingLayoutType loggingLayout, Level level) {
        if (loggingLayout == LoggingLayoutType.TEXT) {
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            ctx.reconfigure();
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            int count = 0;
            for (org.apache.logging.log4j.core.Logger logger : loggerContext.getLoggers()) {
                String loggerName = logger.getName();
                if (!loggerName.startsWith("org.gluu") || logger.getLevel() == level) continue;
                ++count;
                logger.setLevel(level);
            }
            if (count > 0) {
                this.log.info("Updated log level of '{}' loggers to {}", (Object)count, (Object)level.toString());
            }
        }
    }

    public abstract boolean isDisableJdkLogger();

    public abstract String getLoggingLevel();

    public abstract String getExternalLoggerConfiguration();

    public abstract String getLoggingLayout();
}

