/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.gluu.model.DisplayNameEntry;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.Entry;
import org.gluu.search.filter.Filter;
import org.gluu.service.CacheService;

@ApplicationScoped
@Named
public class LookupService
implements Serializable {
    private static final long serialVersionUID = -3707238475653913313L;
    @Inject
    private PersistenceEntryManager persistenceEntryManager;
    @Inject
    private CacheService cacheService;

    public DisplayNameEntry getDisplayNameEntry(String dn) throws Exception {
        String key = "l_" + dn;
        DisplayNameEntry entry = (DisplayNameEntry)this.cacheService.get("LookupCache", key);
        if (entry == null) {
            entry = (DisplayNameEntry)this.persistenceEntryManager.find((Object)dn, DisplayNameEntry.class, null);
            this.cacheService.put("LookupCache", key, (Object)entry);
        }
        return entry;
    }

    public Object getTypedEntry(String dn, String clazz) throws Exception {
        if (StringUtils.isEmpty((CharSequence)clazz)) {
            return null;
        }
        Class<?> entryClass = Class.forName(clazz);
        String key = "l_" + dn;
        Object entry = this.cacheService.get("LookupCache", key);
        if (entry == null) {
            entry = this.persistenceEntryManager.find(entryClass, (Object)dn);
            this.cacheService.put("LookupCache", key, entry);
        }
        return entry;
    }

    public List<DisplayNameEntry> getDisplayNameEntries(String baseDn, List<String> dns) {
        List<String> inums = this.getInumsFromDns(dns);
        if (inums.size() == 0) {
            return null;
        }
        String key = this.getCompoundKey(inums);
        List entries = (List)this.cacheService.get("LookupCache", key);
        if (entries == null) {
            Filter searchFilter = this.buildInumFilter(inums);
            entries = this.persistenceEntryManager.findEntries(baseDn, DisplayNameEntry.class, searchFilter);
            this.cacheService.put("LookupCache", key, (Object)entries);
        }
        return entries;
    }

    public Filter buildInumFilter(List<String> inums) {
        ArrayList<Filter> inumFilters = new ArrayList<Filter>(inums.size());
        for (String inum : inums) {
            inumFilters.add(Filter.createEqualityFilter((String)"inum", (Object)inum).multiValued(Boolean.valueOf(false)));
        }
        return Filter.createORFilter(inumFilters);
    }

    public List<String> getInumsFromDns(List<String> dns) {
        ArrayList<String> inums = new ArrayList<String>();
        if (dns == null) {
            return inums;
        }
        for (String dn : dns) {
            String inum = this.getInumFromDn(dn);
            if (inum == null) continue;
            inums.add(inum);
        }
        Collections.sort(inums);
        return inums;
    }

    private String getCompoundKey(List<String> inums) {
        StringBuilder compoundKey = new StringBuilder();
        for (String inum : inums) {
            if (compoundKey.length() > 0) {
                compoundKey.append("_");
            } else {
                compoundKey.append("l_");
            }
            compoundKey.append(inum);
        }
        return compoundKey.toString();
    }

    public List<DisplayNameEntry> getDisplayNameEntriesByEntries(String baseDn, List<? extends Entry> entries) throws Exception {
        if (entries == null) {
            return null;
        }
        ArrayList<String> dns = new ArrayList<String>(entries.size());
        for (Entry entry : entries) {
            dns.add(entry.getDn());
        }
        return this.getDisplayNameEntries(baseDn, dns);
    }

    public String getInumFromDn(String dn) {
        if (dn == null) {
            return null;
        }
        if (!dn.startsWith("inum=")) {
            return null;
        }
        int idx = dn.indexOf(",", 5);
        if (idx == -1) {
            return null;
        }
        return dn.substring(5, idx);
    }
}

