/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.gluu.model.security.Group;

public class SimpleGroup
implements Group,
Serializable {
    private static final long serialVersionUID = 391089759338334557L;
    private String name;
    private Set<Principal> members = new HashSet<Principal>();

    public SimpleGroup(String name) {
        this.name = name;
    }

    @Override
    public boolean addMember(Principal user) {
        return this.members.add(user);
    }

    @Override
    public boolean isMember(Principal member) {
        if (this.members.contains(member)) {
            return true;
        }
        for (Principal m : this.members) {
            if (!(m instanceof Group) || !((Group)m).isMember(member)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Enumeration<? extends Principal> members() {
        return Collections.enumeration(this.members);
    }

    @Override
    public boolean removeMember(Principal user) {
        return this.members.remove(user);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SimpleGroup) {
            SimpleGroup other = (SimpleGroup)obj;
            return other.name.equals(this.name);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }
}

