/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.metric;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gluu.model.ApplicationType;
import org.gluu.model.metric.MetricType;
import org.gluu.model.metric.ldap.MetricEntry;
import org.gluu.model.metric.ldap.MetricReport;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.model.DefaultBatchOperation;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.metric.LdapEntryReporter;
import org.gluu.service.metric.inject.ReportMetric;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

public abstract class MetricService
implements Serializable {
    private static final long serialVersionUID = -3393618600428448743L;
    private static final String EVENT_TYPE = "MetricServiceTimerEvent";
    private static final int DEFAULT_METRIC_REPORTER_INTERVAL = 60;
    private static final SimpleDateFormat PERIOD_DATE_FORMAT = new SimpleDateFormat("yyyyMM");
    private static final AtomicLong INITIAL_ID = new AtomicLong(System.currentTimeMillis());
    private MetricRegistry metricRegistry;
    private Set<MetricType> registeredMetricTypes;
    private int entryLifetimeInDays;
    private LdapEntryReporter ldapEntryReporter;
    @Inject
    private Logger log;

    public void initTimer(int metricInterval, int entryLifetimeInDays) {
        this.metricRegistry = new MetricRegistry();
        this.registeredMetricTypes = new HashSet<MetricType>();
        this.entryLifetimeInDays = entryLifetimeInDays;
        this.ldapEntryReporter = LdapEntryReporter.forRegistry(this.metricRegistry, this.getMetricServiceInstance()).build();
        int metricReporterInterval = metricInterval;
        if (metricReporterInterval <= 0) {
            metricReporterInterval = 60;
        }
        this.ldapEntryReporter.start(metricReporterInterval, TimeUnit.SECONDS);
    }

    public void close() {
        if (this.ldapEntryReporter != null) {
            this.ldapEntryReporter.close();
        }
    }

    public int getEntryLifetimeInDays() {
        return this.entryLifetimeInDays;
    }

    @Asynchronous
    public void writeMetricEntries(@Observes @ReportMetric MetricReport metricReport) {
        this.add(metricReport.getMetricEntries(), metricReport.getCreationTime());
    }

    public void addBranch(String branchDn, String ou) {
        if (this.getEntryManager().hasBranchesSupport(branchDn)) {
            SimpleBranch branch = new SimpleBranch();
            branch.setOrganizationalUnitName(ou);
            branch.setDn(branchDn);
            this.getEntryManager().persist((Object)branch);
        }
    }

    public boolean containsBranch(String branchDn) {
        if (this.getEntryManager().hasBranchesSupport(branchDn)) {
            return this.getEntryManager().contains(branchDn, SimpleBranch.class);
        }
        return true;
    }

    public void createBranch(String branchDn, String ou) {
        block2: {
            try {
                this.addBranch(branchDn, ou);
            }
            catch (EntryPersistenceException ex) {
                if (this.containsBranch(branchDn)) break block2;
                throw ex;
            }
        }
    }

    public void prepareBranch(Date creationDate, ApplicationType applicationType) {
        if (!this.getEntryManager().hasBranchesSupport(this.baseDn())) {
            return;
        }
        String baseDn = this.buildDn(null, creationDate, applicationType);
        if (!this.containsBranch(baseDn)) {
            this.createApplicationBaseBranch(applicationType);
            if (creationDate != null) {
                this.createBranch(baseDn, PERIOD_DATE_FORMAT.format(creationDate));
            }
        }
    }

    protected void createApplicationBaseBranch(ApplicationType applicationType) {
        String applicationBaseDn = this.buildDn(null, null, applicationType);
        if (!this.containsBranch(applicationBaseDn)) {
            this.createBranch(applicationBaseDn, applicationType.getValue());
        }
    }

    public void add(List<MetricEntry> metricEntries, Date creationTime) {
        this.prepareBranch(creationTime, this.getApplicationType());
        for (MetricEntry metricEntry : metricEntries) {
            this.getEntryManager().persist((Object)metricEntry);
        }
    }

    public void add(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.getEntryManager().persist((Object)metricEntry);
    }

    public void update(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.getEntryManager().merge((Object)metricEntry);
    }

    public void remove(MetricEntry metricEntry) {
        this.prepareBranch(metricEntry.getCreationDate(), metricEntry.getApplicationType());
        this.getEntryManager().remove((Object)metricEntry);
    }

    public void removeBranch(String branchDn) {
        this.getEntryManager().removeRecursively(branchDn);
    }

    public MetricEntry getMetricEntryByDn(MetricType metricType, String metricEventDn) {
        return (MetricEntry)this.getEntryManager().find(metricType.getMetricEntryType(), (Object)metricEventDn);
    }

    public Map<MetricType, List<? extends MetricEntry>> findMetricEntry(ApplicationType applicationType, List<MetricType> metricTypes, Date startDate, Date endDate, String ... returnAttributes) {
        this.prepareBranch(null, applicationType);
        HashMap<MetricType, List<? extends MetricEntry>> result = new HashMap<MetricType, List<? extends MetricEntry>>();
        if (metricTypes == null || metricTypes.size() == 0) {
            return result;
        }
        Set<String> metricDns = this.getBaseDnForPeriod(applicationType, startDate, endDate);
        if (metricDns.size() == 0) {
            return result;
        }
        for (MetricType metricType : metricTypes) {
            LinkedList metricTypeResult = new LinkedList();
            for (String metricDn : metricDns) {
                ArrayList<Filter> metricTypeFilters = new ArrayList<Filter>();
                Filter applicationTypeFilter = Filter.createEqualityFilter((String)"oxApplicationType", (Object)applicationType.getValue());
                Filter eventTypeTypeFilter = Filter.createEqualityFilter((String)"oxMetricType", (Object)metricType.getValue());
                Filter startDateFilter = Filter.createGreaterOrEqualFilter((String)"oxStartDate", (Object)this.getEntryManager().encodeTime(metricDn, startDate));
                Filter endDateFilter = Filter.createLessOrEqualFilter((String)"oxEndDate", (Object)this.getEntryManager().encodeTime(metricDn, endDate));
                metricTypeFilters.add(applicationTypeFilter);
                metricTypeFilters.add(eventTypeTypeFilter);
                metricTypeFilters.add(startDateFilter);
                metricTypeFilters.add(endDateFilter);
                Filter filter = Filter.createANDFilter(metricTypeFilters);
                List metricTypeMonthResult = this.getEntryManager().findEntries(metricDn, metricType.getMetricEntryType(), filter, returnAttributes);
                metricTypeResult.addAll(metricTypeMonthResult);
            }
            this.getEntryManager().sortListByProperties(MetricEntry.class, metricTypeResult, false, new String[]{"creationDate"});
            result.put(metricType, metricTypeResult);
        }
        return result;
    }

    public List<MetricEntry> getExpiredMetricEntries(DefaultBatchOperation<MetricEntry> batchOperation, String baseDnForPeriod, Date expirationDate, int count, int chunkSize) {
        Filter expiratioFilter = Filter.createLessOrEqualFilter((String)"oxStartDate", (Object)this.getEntryManager().encodeTime(baseDnForPeriod, expirationDate));
        List metricEntries = this.getEntryManager().findEntries(baseDnForPeriod, MetricEntry.class, expiratioFilter, SearchScope.SUB, new String[]{"uniqueIdentifier"}, batchOperation, 0, count, chunkSize);
        return metricEntries;
    }

    public List<SimpleBranch> findAllPeriodBranches(DefaultBatchOperation<SimpleBranch> batchOperation, ApplicationType applicationType, int count, int chunkSize) {
        String baseDn = this.buildDn(null, null, applicationType);
        Filter skipRootDnFilter = Filter.createNOTFilter((Filter)Filter.createEqualityFilter((String)"ou", (Object)applicationType.getValue()));
        return this.getEntryManager().findEntries(baseDn, SimpleBranch.class, skipRootDnFilter, SearchScope.SUB, new String[]{"ou"}, batchOperation, 0, count, chunkSize);
    }

    public void removeExpiredMetricEntries(Date expirationDate, final ApplicationType applicationType, int count, int chunkSize) {
        this.createApplicationBaseBranch(this.getApplicationType());
        final Set<String> keepBaseDnForPeriod = this.getBaseDnForPeriod(applicationType, expirationDate, new Date());
        for (String baseDnForPeriod : keepBaseDnForPeriod) {
            DefaultBatchOperation<MetricEntry> metricEntryBatchOperation = new DefaultBatchOperation<MetricEntry>(){

                public boolean collectSearchResult(int size) {
                    return false;
                }

                public void performAction(List<MetricEntry> entries) {
                    for (MetricEntry metricEntry : entries) {
                        MetricService.this.remove(metricEntry);
                    }
                }
            };
            this.getExpiredMetricEntries(metricEntryBatchOperation, baseDnForPeriod, expirationDate, count, chunkSize);
        }
        DefaultBatchOperation<SimpleBranch> batchOperation = new DefaultBatchOperation<SimpleBranch>(){

            public boolean collectSearchResult(int size) {
                return false;
            }

            public void performAction(List<SimpleBranch> objects) {
                String baseDn = MetricService.this.buildDn(null, null, applicationType);
                HashSet<String> periodBranchesStrings = new HashSet<String>();
                for (SimpleBranch periodBranch : objects) {
                    if (StringHelper.equalsIgnoreCase((String)baseDn, (String)periodBranch.getDn())) continue;
                    periodBranchesStrings.add(periodBranch.getDn());
                }
                periodBranchesStrings.removeAll(keepBaseDnForPeriod);
                for (String baseDnForPeriod : periodBranchesStrings) {
                    MetricService.this.removeBranch(baseDnForPeriod);
                }
            }
        };
        this.findAllPeriodBranches(batchOperation, applicationType, count, chunkSize);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set<String> getBaseDnForPeriod(ApplicationType applicationType, Date startDate, Date endDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone("UTC"));
        cal.setTime(startDate);
        Calendar calEndMonth = Calendar.getInstance();
        calEndMonth.setTimeZone(TimeZone.getTimeZone("UTC"));
        calEndMonth.setTime(endDate);
        int endMonth = calEndMonth.get(2);
        HashSet<String> metricDns = new HashSet<String>();
        boolean stopCondition = cal.getTime().equals(endDate);
        cal.setTime(startDate);
        while (true) {
            int currentMonth = cal.get(2);
            Date currentStartDate = cal.getTime();
            String baseDn = this.buildDn(null, currentStartDate, applicationType);
            if (this.containsBranch(baseDn)) {
                metricDns.add(baseDn);
            }
            if (stopCondition) return metricDns;
            cal.add(2, 1);
            if (!cal.getTime().after(endDate)) continue;
            stopCondition = true;
            if (currentMonth == endMonth) return metricDns;
        }
    }

    public String getUiqueIdentifier() {
        return UUID.randomUUID().toString();
    }

    public Counter getCounter(MetricType metricType) {
        if (!this.registeredMetricTypes.contains(metricType)) {
            this.registeredMetricTypes.add(metricType);
        }
        return this.metricRegistry.counter(metricType.getMetricName());
    }

    public Timer getTimer(MetricType metricType) {
        if (!this.registeredMetricTypes.contains(metricType)) {
            this.registeredMetricTypes.add(metricType);
        }
        return this.metricRegistry.timer(metricType.getMetricName());
    }

    public void incCounter(MetricType metricType) {
        Counter counter = this.getCounter(metricType);
        counter.inc();
    }

    public String buildDn(String uniqueIdentifier, Date creationDate, ApplicationType applicationType) {
        StringBuilder dn = new StringBuilder();
        if (StringHelper.isNotEmpty((String)uniqueIdentifier) && creationDate != null && applicationType != null) {
            dn.append(String.format("uniqueIdentifier=%s,", uniqueIdentifier));
        }
        if (creationDate != null && applicationType != null) {
            dn.append(String.format("ou=%s,", PERIOD_DATE_FORMAT.format(creationDate)));
        }
        if (applicationType != null) {
            dn.append(String.format("ou=%s,", applicationType.getValue()));
        }
        dn.append(this.baseDn());
        return dn.toString();
    }

    public Set<MetricType> getRegisteredMetricTypes() {
        return this.registeredMetricTypes;
    }

    public abstract String baseDn();

    public abstract MetricService getMetricServiceInstance();

    public abstract boolean isMetricReporterEnabled();

    public abstract ApplicationType getApplicationType();

    public abstract String getNodeIndetifier();

    public abstract PersistenceEntryManager getEntryManager();
}

