/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.logger;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.LogManager;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.RollingFileAppender;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.JsonLayout;
import org.gluu.model.types.LoggingLayoutType;
import org.gluu.service.cdi.async.Asynchronous;
import org.gluu.service.cdi.event.ConfigurationUpdate;
import org.gluu.service.cdi.event.LoggerUpdateEvent;
import org.gluu.service.cdi.event.Scheduled;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

public abstract class LoggerService {
    private static final int DEFAULT_INTERVAL = 15;
    @Inject
    private Logger log;
    @Inject
    private Event<TimerEvent> timerEvent;
    private AtomicBoolean isActive;

    @PostConstruct
    public void create() {
        this.isActive = new AtomicBoolean(false);
    }

    public void initTimer() {
        this.log.info("Initializing Logger Update Timer");
        int delay = 15;
        int interval = 15;
        this.timerEvent.fire((Object)new TimerEvent(new TimerSchedule(15, 15), (Object)new LoggerUpdateEvent(), new Annotation[]{Scheduled.Literal.INSTANCE}));
    }

    @Asynchronous
    public void updateLoggerTimerEvent(@Observes @Scheduled LoggerUpdateEvent loggerUpdateEvent) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerConfiguration();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating newly added logger configuration", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void updateLoggerConfiguration() {
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel)) {
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        if (StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            return;
        }
        if (StringUtils.isEmpty((String)this.getLoggingLayout())) {
            return;
        }
        LoggingLayoutType loggingLayout = LoggingLayoutType.getByValue((String)this.getLoggingLayout().toUpperCase());
        if (loggingLayout == LoggingLayoutType.TEXT) {
            LoggerContext ctx = LoggerContext.getContext((boolean)false);
            ctx.reconfigure();
            this.updateLoggers(level);
        } else if (loggingLayout == LoggingLayoutType.JSON) {
            this.updateAppendersToJson(level);
        }
    }

    public void updateLoggerSeverity(@Observes @ConfigurationUpdate Object appConfiguration) {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.updateLoggerSeverityImpl();
        }
        catch (Throwable ex) {
            this.log.error("Exception happened while updating logger configuration after base configuration update", ex);
        }
        finally {
            this.isActive.set(false);
        }
    }

    public void updateLoggerSeverity() {
        this.updateLoggerSeverityImpl();
    }

    private void updateLoggerSeverityImpl() {
        if (this.isDisableJdkLogger()) {
            this.disableJdkLogger();
        }
        this.updateLoggerConfigLocation();
        String loggingLevel = this.getLoggingLevel();
        if (StringHelper.isEmpty((String)loggingLevel)) {
            return;
        }
        this.log.info("Setting loggers level to: '{}'", (Object)loggingLevel);
        if (StringHelper.equalsIgnoreCase((String)"DEFAULT", (String)loggingLevel)) {
            this.log.info("Reloading log4j configuration");
            LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
            loggerContext.reconfigure();
            return;
        }
        Level level = Level.toLevel((String)loggingLevel, (Level)Level.INFO);
        this.updateLoggers(level);
    }

    private void updateLoggers(Level level) {
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        int count = 0;
        for (org.apache.logging.log4j.core.Logger logger : loggerContext.getLoggers()) {
            String loggerName = logger.getName();
            if (!loggerName.startsWith("org.gluu") || logger.getLevel() == level) continue;
            ++count;
            logger.setLevel(level);
        }
        if (count > 0) {
            this.log.info("Updated log level of '{}' loggers to {}", (Object)count, (Object)level.toString());
        }
    }

    public void updateLoggerConfigLocation() {
        if (this.setExternalLoggerConfig()) {
            return;
        }
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        if (loggerContext.getConfigLocation() != null) {
            loggerContext.setConfigLocation(null);
            loggerContext.reconfigure();
        }
    }

    private void disableJdkLogger() {
        LogManager.getLogManager().reset();
        java.util.logging.Logger globalLogger = java.util.logging.Logger.getLogger("global");
        if (globalLogger != null) {
            globalLogger.setLevel(java.util.logging.Level.OFF);
        }
    }

    private boolean setExternalLoggerConfig() {
        String externalLoggerConfiguration = this.getExternalLoggerConfiguration();
        this.log.info("External log configuration: {}", (Object)externalLoggerConfiguration);
        if (StringUtils.isEmpty((String)externalLoggerConfiguration)) {
            return false;
        }
        File log4jFile = new File(externalLoggerConfiguration);
        if (!log4jFile.exists()) {
            this.log.info("External log configuration does not exist.");
            return false;
        }
        LoggerContext loggerContext = LoggerContext.getContext((boolean)false);
        loggerContext.setConfigLocation(log4jFile.toURI());
        loggerContext.reconfigure();
        return true;
    }

    private void updateAppendersToJson(Level level) {
        JsonLayout jsonLayout = JsonLayout.createDefaultLayout();
        LoggerContext ctx = LoggerContext.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("root");
        for (Map.Entry appenderEntry : loggerConfig.getAppenders().entrySet()) {
            if (appenderEntry.getValue() instanceof RollingFileAppender) {
                RollingFileAppender rollingFile = (RollingFileAppender)appenderEntry.getValue();
                if (rollingFile.getLayout() instanceof JsonLayout) {
                    return;
                }
                RollingFileAppender newFileAppender = ((RollingFileAppender.Builder)((RollingFileAppender.Builder)RollingFileAppender.newBuilder().setLayout((Layout)jsonLayout)).withStrategy(((RollingFileManager)rollingFile.getManager()).getRolloverStrategy()).withPolicy(rollingFile.getTriggeringPolicy()).withFileName(rollingFile.getFileName()).withFilePattern(rollingFile.getFilePattern()).setName(rollingFile.getName())).build();
                loggerConfig.removeAppender((String)appenderEntry.getKey());
                loggerConfig.addAppender((Appender)newFileAppender, level, null);
                continue;
            }
            if (!(appenderEntry.getValue() instanceof ConsoleAppender)) continue;
            ConsoleAppender consoleAppender = (ConsoleAppender)appenderEntry.getValue();
            if (consoleAppender.getLayout() instanceof JsonLayout) {
                return;
            }
            ConsoleAppender newConsoleAppender = ((ConsoleAppender.Builder)((ConsoleAppender.Builder)ConsoleAppender.newBuilder().setLayout((Layout)jsonLayout)).setTarget(consoleAppender.getTarget()).setName(consoleAppender.getName())).build();
            loggerConfig.removeAppender((String)appenderEntry.getKey());
            loggerConfig.addAppender((Appender)newConsoleAppender, level, null);
        }
        ctx.updateLoggers();
    }

    public abstract boolean isDisableJdkLogger();

    public abstract String getLoggingLevel();

    public abstract String getExternalLoggerConfiguration();

    public abstract String getLoggingLayout();
}

