/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.external;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.type.persistence.PersistenceType;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.exception.extension.PersistenceExtension;
import org.gluu.service.custom.script.ExternalScriptService;
import org.gluu.service.external.context.PersistenceExternalContext;

@ApplicationScoped
public class ExternalPersistenceExtensionService
extends ExternalScriptService {
    private static final long serialVersionUID = 5466361778036208685L;
    @Inject
    private Instance<PersistenceEntryManager> persistenceEntryManagerInstance;
    @Inject
    private Instance<List<PersistenceEntryManager>> persistenceEntryManagerListInstance;

    public ExternalPersistenceExtensionService() {
        super(CustomScriptType.PERSISTENCE_EXTENSION);
    }

    protected void reloadExternal() {
        for (PersistenceEntryManager persistenceEntryManager : this.persistenceEntryManagerInstance) {
            this.executePersistenceExtensionAfterCreate(null, persistenceEntryManager);
        }
        for (List persistenceEntryManagerList : this.persistenceEntryManagerListInstance) {
            for (PersistenceEntryManager persistenceEntryManager : persistenceEntryManagerList) {
                this.executePersistenceExtensionAfterCreate(null, persistenceEntryManager);
            }
        }
    }

    public void executePersistenceExtensionAfterCreate(Properties connectionProperties, PersistenceEntryManager persistenceEntryManager) {
        if (this.isEnabled()) {
            PersistenceExternalContext persistenceExternalContext = new PersistenceExternalContext();
            persistenceExternalContext.setConnectionProperties(connectionProperties);
            persistenceExternalContext.setPersistenceEntryManager(persistenceEntryManager);
            this.executeExternalOnAfterCreateMethod(persistenceExternalContext);
            this.setPersistenceExtension(persistenceEntryManager);
        }
    }

    public void executePersistenceExtensionAfterDestroy(PersistenceEntryManager persistenceEntryManager) {
        if (this.isEnabled()) {
            PersistenceExternalContext persistenceExternalContext = new PersistenceExternalContext();
            persistenceExternalContext.setPersistenceEntryManager(persistenceEntryManager);
            this.executeExternalOnAfterDestroyMethod(persistenceExternalContext);
        }
    }

    public void setPersistenceExtension(PersistenceEntryManager persistenceEntryManager) {
        PersistenceExtension persistenceExtension = null;
        if (this.isEnabled()) {
            persistenceExtension = (PersistenceExtension)this.defaultExternalCustomScript.getExternalType();
        }
        persistenceEntryManager.setPersistenceExtension(persistenceExtension);
    }

    public void executeExternalOnAfterCreateMethod(PersistenceExternalContext context) {
        this.executeExternalOnAfterCreateMethod(this.defaultExternalCustomScript, context);
    }

    public void executeExternalOnAfterCreateMethod(CustomScriptConfiguration customScriptConfiguration, PersistenceExternalContext context) {
        try {
            this.log.debug("Executing python 'onAfterCreate' method");
            PersistenceType persistenceType = (PersistenceType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            persistenceType.onAfterCreate((Object)context, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
        }
    }

    public void executeExternalOnAfterDestroyMethod(PersistenceExternalContext context) {
        this.executeExternalOnAfterDestroyMethod(this.defaultExternalCustomScript, context);
    }

    public void executeExternalOnAfterDestroyMethod(CustomScriptConfiguration customScriptConfiguration, PersistenceExternalContext context) {
        try {
            this.log.debug("Executing python 'onAfterDestroy' method");
            PersistenceType persistenceType = (PersistenceType)customScriptConfiguration.getExternalType();
            Map configurationAttributes = customScriptConfiguration.getConfigurationAttributes();
            persistenceType.onAfterDestroy((Object)context, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
        }
    }
}

