/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.lib;

import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@ApplicationScoped
public class CustomLibrariesLoader
implements Serializable {
    private static final long serialVersionUID = 3918267172467576424L;
    private static final String SERVER_BASE_PATH = "server.base";
    private static final String CUSTOM_LIBS_PATH = "/custom/libs";
    @Inject
    protected Logger log;

    public void init() {
        this.loadCustomLibraries();
    }

    private void loadCustomLibraries() {
        try {
            String[] paths;
            String customLibrariesPath = CustomLibrariesLoader.getCustomLibrariesPath();
            if (StringHelper.isEmpty((String)customLibrariesPath)) {
                return;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            ClassLoader webAppClassLoader = Thread.currentThread().getContextClassLoader();
            for (String path : paths = new String[]{customLibrariesPath}) {
                File parent = new File(path);
                File[] jars = parent.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar");
                    }
                });
                if (jars == null) continue;
                for (File jar : jars) {
                    method.invoke((Object)webAppClassLoader, jar.toURI().toURL());
                    this.log.debug("Loaded custom library '{}'", (Object)jar.toURI().toURL());
                }
            }
            method.setAccessible(false);
        }
        catch (Exception ex) {
            this.log.error("Failed to register custom libraries");
        }
    }

    public static String getCustomLibrariesPath() {
        String externalResourceBase = System.getProperty(SERVER_BASE_PATH);
        if (StringHelper.isNotEmpty((String)externalResourceBase)) {
            externalResourceBase = externalResourceBase + CUSTOM_LIBS_PATH;
            return externalResourceBase;
        }
        return null;
    }
}

