/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.model;

import java.io.Serializable;
import java.util.Arrays;
import javax.persistence.Transient;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.gluu.model.GluuAttributeUsageType;
import org.gluu.model.GluuStatus;
import org.gluu.model.GluuUserRole;
import org.gluu.model.attribute.AttributeDataType;
import org.gluu.model.attribute.AttributeValidation;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.JsonObject;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.Entry;

@DataEntry(sortBy={"displayName"})
@ObjectClass(value="gluuAttribute")
public class GluuAttribute
extends Entry
implements Serializable {
    private static final long serialVersionUID = 4817004894646725606L;
    private transient boolean selected;
    @AttributeName(ignoreDuringUpdate=true)
    private String inum;
    @AttributeName
    private String lifetime;
    @AttributeName(name="oxSourceAttribute")
    private String sourceAttribute;
    @AttributeName
    private String salt;
    @AttributeName(name="oxNameIdType")
    private String nameIdType;
    @NotNull
    @Pattern(regexp="^[a-zA-Z0-9_]+$", message="Name should contain alphabetical and numeric characters only")
    @Size(min=1, max=30, message="Length of the Name should be between 1 and 30")
    @AttributeName(name="gluuAttributeName")
    private @NotNull @Pattern(regexp="^[a-zA-Z0-9_]+$", message="Name should contain alphabetical and numeric characters only") @Size(min=1, max=30, message="Length of the Name should be between 1 and 30") String name;
    @NotNull
    @Size(min=0, max=60, message="Length of the Display Name should not exceed 60")
    @AttributeName
    private @NotNull @Size(min=0, max=60, message="Length of the Display Name should not exceed 60") String displayName;
    @NotNull
    @Size(min=0, max=4000, message="Length of the Description should not exceed 4000")
    @AttributeName
    private @NotNull @Size(min=0, max=4000, message="Length of the Description should not exceed 4000") String description;
    @AttributeName(name="gluuAttributeOrigin")
    private String origin;
    @NotNull
    @AttributeName(name="gluuAttributeType")
    private AttributeDataType dataType;
    @NotNull
    @AttributeName(name="gluuAttributeEditType")
    private GluuUserRole[] editType;
    @NotNull
    @AttributeName(name="gluuAttributeViewType")
    private GluuUserRole[] viewType;
    @AttributeName(name="gluuAttributeUsageType")
    private GluuAttributeUsageType[] usageType;
    @AttributeName(name="oxAuthClaimName")
    private String oxAuthClaimName;
    @AttributeName(name="seeAlso")
    private String seeAlso;
    @AttributeName(name="gluuStatus")
    private GluuStatus status;
    @AttributeName(name="gluuSAML1URI")
    private String saml1Uri;
    @AttributeName(name="gluuSAML2URI")
    private String saml2Uri;
    @AttributeName(ignoreDuringUpdate=true)
    private String urn;
    @AttributeName(name="oxSCIMCustomAttribute")
    private Boolean oxSCIMCustomAttribute;
    @AttributeName(name="oxMultivaluedAttribute")
    private Boolean oxMultiValuedAttribute;
    @Transient
    private boolean custom;
    @Transient
    private boolean requred;
    @JsonObject
    @AttributeName(name="oxValidation")
    private AttributeValidation attributeValidation;
    @AttributeName(name="gluuTooltip")
    private String gluuTooltip;

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getInum() {
        return this.inum;
    }

    public void setInum(String inum) {
        this.inum = inum;
    }

    public String getLifetime() {
        return this.lifetime;
    }

    public void setLifetime(String lifetime) {
        this.lifetime = lifetime;
    }

    public String getSourceAttribute() {
        return this.sourceAttribute;
    }

    public void setSourceAttribute(String sourceAttribute) {
        this.sourceAttribute = sourceAttribute;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public String getNameIdType() {
        return this.nameIdType;
    }

    public void setNameIdType(String nameIdType) {
        this.nameIdType = nameIdType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public AttributeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(AttributeDataType dataType) {
        this.dataType = dataType;
    }

    public GluuUserRole[] getEditType() {
        return this.editType;
    }

    public void setEditType(GluuUserRole[] editType) {
        this.editType = editType;
    }

    public GluuUserRole[] getViewType() {
        return this.viewType;
    }

    public void setViewType(GluuUserRole[] viewType) {
        this.viewType = viewType;
    }

    public GluuAttributeUsageType[] getUsageType() {
        return this.usageType;
    }

    public void setUsageType(GluuAttributeUsageType[] usageType) {
        this.usageType = usageType;
    }

    public String getOxAuthClaimName() {
        return this.oxAuthClaimName;
    }

    public void setOxAuthClaimName(String oxAuthClaimName) {
        this.oxAuthClaimName = oxAuthClaimName;
    }

    public String getSeeAlso() {
        return this.seeAlso;
    }

    public void setSeeAlso(String seeAlso) {
        this.seeAlso = seeAlso;
    }

    public GluuStatus getStatus() {
        return this.status;
    }

    public void setStatus(GluuStatus status) {
        this.status = status;
    }

    public String getSaml1Uri() {
        return this.saml1Uri;
    }

    public void setSaml1Uri(String saml1Uri) {
        this.saml1Uri = saml1Uri;
    }

    public String getSaml2Uri() {
        return this.saml2Uri;
    }

    public void setSaml2Uri(String saml2Uri) {
        this.saml2Uri = saml2Uri;
    }

    public String getUrn() {
        return this.urn;
    }

    public void setUrn(String urn) {
        this.urn = urn;
    }

    public Boolean getOxSCIMCustomAttribute() {
        return this.oxSCIMCustomAttribute;
    }

    public void setOxSCIMCustomAttribute(Boolean oxSCIMCustomAttribute) {
        this.oxSCIMCustomAttribute = oxSCIMCustomAttribute;
    }

    public Boolean getOxMultiValuedAttribute() {
        return this.oxMultiValuedAttribute == null ? false : this.oxMultiValuedAttribute;
    }

    public void setOxMultiValuedAttribute(Boolean oxMultiValuedAttribute) {
        this.oxMultiValuedAttribute = oxMultiValuedAttribute;
    }

    public boolean isCustom() {
        return this.custom;
    }

    public void setCustom(boolean custom) {
        this.custom = custom;
    }

    public boolean isRequred() {
        return this.requred;
    }

    public void setRequred(boolean requred) {
        this.requred = requred;
    }

    public String getGluuTooltip() {
        return this.gluuTooltip;
    }

    public void setGluuTooltip(String gluuTooltip) {
        this.gluuTooltip = gluuTooltip;
    }

    public boolean allowEditBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.editType, role);
    }

    public boolean allowViewBy(GluuUserRole role) {
        return GluuUserRole.containsRole(this.viewType, role);
    }

    public boolean isAdminCanAccess() {
        return this.isAdminCanView() | this.isAdminCanEdit();
    }

    public boolean isAdminCanView() {
        return this.allowViewBy(GluuUserRole.ADMIN);
    }

    public boolean isAdminCanEdit() {
        return this.allowEditBy(GluuUserRole.ADMIN);
    }

    public boolean isUserCanAccess() {
        return this.isUserCanView() | this.isUserCanEdit();
    }

    public boolean isUserCanView() {
        return this.allowViewBy(GluuUserRole.USER);
    }

    public boolean isWhitePagesCanView() {
        return this.allowViewBy(GluuUserRole.WHITEPAGES);
    }

    public boolean isUserCanEdit() {
        return this.allowEditBy(GluuUserRole.USER);
    }

    public AttributeValidation getAttributeValidation() {
        return this.attributeValidation;
    }

    public void setAttributeValidation(AttributeValidation attributeValidation) {
        this.attributeValidation = attributeValidation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.custom ? 1231 : 1237);
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.editType);
        result = 31 * result + (this.gluuTooltip == null ? 0 : this.gluuTooltip.hashCode());
        result = 31 * result + (this.inum == null ? 0 : this.inum.hashCode());
        result = 31 * result + (this.lifetime == null ? 0 : this.lifetime.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.nameIdType == null ? 0 : this.nameIdType.hashCode());
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.oxAuthClaimName == null ? 0 : this.oxAuthClaimName.hashCode());
        result = 31 * result + (this.oxMultiValuedAttribute == null ? 0 : this.oxMultiValuedAttribute.hashCode());
        result = 31 * result + (this.oxSCIMCustomAttribute == null ? 0 : this.oxSCIMCustomAttribute.hashCode());
        result = 31 * result + (this.requred ? 1231 : 1237);
        result = 31 * result + (this.salt == null ? 0 : this.salt.hashCode());
        result = 31 * result + (this.saml1Uri == null ? 0 : this.saml1Uri.hashCode());
        result = 31 * result + (this.saml2Uri == null ? 0 : this.saml2Uri.hashCode());
        result = 31 * result + (this.seeAlso == null ? 0 : this.seeAlso.hashCode());
        result = 31 * result + (this.sourceAttribute == null ? 0 : this.sourceAttribute.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.urn == null ? 0 : this.urn.hashCode());
        result = 31 * result + Arrays.hashCode((Object[])this.usageType);
        result = 31 * result + Arrays.hashCode((Object[])this.viewType);
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GluuAttribute)) {
            return false;
        }
        GluuAttribute other = (GluuAttribute)obj;
        if (this.inum == null ? other.inum != null : !this.inum.equals(other.inum)) {
            return false;
        }
        if (this.custom != other.custom) {
            return false;
        }
        if (this.dataType != other.dataType) {
            return false;
        }
        return !(this.description == null ? other.description != null : !this.description.equals(other.description));
    }
}

