/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.timer;

import java.util.Date;
import java.util.UUID;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gluu.service.timer.JobExecutionFactory;
import org.gluu.service.timer.RequestJobListener;
import org.gluu.service.timer.TimerJob;
import org.gluu.service.timer.event.TimerEvent;
import org.gluu.service.timer.schedule.JobShedule;
import org.gluu.service.timer.schedule.TimerSchedule;
import org.gluu.util.init.Initializable;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.Matcher;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.EverythingMatcher;
import org.quartz.spi.JobFactory;
import org.slf4j.Logger;

@ApplicationScoped
public class QuartzSchedulerManager
extends Initializable {
    public static final String QUARTZ_PROPERTY_FILE_NAME = "quartz.properties";
    @Inject
    private Logger log;
    @Inject
    private RequestJobListener jobListener;
    @Inject
    private JobExecutionFactory jobFactory;
    private Scheduler scheduler;

    protected void initInternal() {
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            factory.initialize(QUARTZ_PROPERTY_FILE_NAME);
            this.scheduler = factory.getScheduler();
            this.scheduler.getListenerManager().addJobListener((JobListener)this.jobListener, (Matcher)EverythingMatcher.allJobs());
            this.scheduler.setJobFactory((JobFactory)this.jobFactory);
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to initialize Quartz scheduler manager", ex);
        }
        this.log.info("Quartz scheduler manager initialized");
    }

    public void schedule(JobShedule jobShedule) {
        this.schedule(jobShedule.getJobDetail(), jobShedule.getTrigger());
    }

    public void schedule(JobDetail jobDetail, Trigger trigger) {
        this.checkInitialized();
        try {
            this.scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to shedule Quartz job", ex);
        }
    }

    public void schedule(@Observes TimerEvent timerEvent) {
        this.checkInitialized();
        JobDataMap dataMap = new JobDataMap();
        dataMap.put(TimerJob.KEY_TIMER_EVENT, (Object)timerEvent);
        String uuid = UUID.randomUUID().toString();
        JobDetail timerJob = JobBuilder.newJob(TimerJob.class).withIdentity(TimerJob.class.getSimpleName() + "_" + uuid, "TimerJobGroup").usingJobData(dataMap).build();
        TimerSchedule timerSchedule = timerEvent.getSchedule();
        Date triggerStartTime = new Date(System.currentTimeMillis() + (long)timerSchedule.getDelay() * 1000L);
        Trigger timerTrigger = TriggerBuilder.newTrigger().withIdentity(uuid, "TimerJobGroup").startAt(triggerStartTime).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.repeatSecondlyForever((int)timerSchedule.getInterval())).build();
        try {
            this.scheduler.scheduleJob(timerJob, timerTrigger);
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to schedule Timer Event", ex);
        }
    }

    public void start() {
        if (!this.isInitialized()) {
            super.init();
        }
        this.checkInitialized();
        try {
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to start Quartz sheduler", ex);
        }
        this.log.info("Quartz scheduler started");
    }

    public void standby() {
        this.checkInitialized();
        try {
            this.scheduler.standby();
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to set Quartz sheduler stand-by mode", ex);
        }
        this.log.info("Quartz scheduler in stand-by mode");
    }

    public void clear() {
        this.checkInitialized();
        try {
            this.scheduler.clear();
        }
        catch (SchedulerException ex) {
            throw new IllegalStateException("Failed to clear Quartz sheduler", ex);
        }
        this.log.info("Quartz scheduler is clear now");
    }

    @PreDestroy
    public void destroy() {
        if (!this.isInitialized()) {
            return;
        }
        try {
            this.scheduler.shutdown();
            this.log.info("Quartz scheduler manager destroyed");
        }
        catch (SchedulerException ex) {
            this.log.warn("Cannot shutdown quartz scheduler!", (Throwable)ex);
        }
    }

    public boolean isInitialized() {
        return this.scheduler != null;
    }

    private void checkInitialized() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("Quartz scheduler manager not initialized!");
        }
    }
}

