/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.security;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.gluu.service.el.ExpressionEvaluator;
import org.gluu.service.security.InterceptSecure;
import org.gluu.service.security.Secure;
import org.gluu.service.security.SecureVariable;
import org.gluu.service.security.SecurityEvaluationException;
import org.gluu.service.security.SecurityExtension;
import org.slf4j.Logger;

@Interceptor
@InterceptSecure(value={})
@Priority(value=4000)
public class SecurityInterceptor
implements Serializable {
    private static final long serialVersionUID = 8227941471496200128L;
    @Inject
    private Logger log;
    @Inject
    private SecurityExtension securityExtension;
    @Inject
    private ExpressionEvaluator expressionEvaluator;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        InterceptSecure is = this.securityExtension.getInterceptSecure(ctx.getMethod());
        Secure[] constraints = is == null ? new Secure[]{} : is.value();
        Map<String, Object> secureVars = this.computeParameterValues(ctx);
        for (Secure constraint : constraints) {
            Boolean expressionValue = this.expressionEvaluator.evaluateValueExpression(constraint.value(), Boolean.class, secureVars);
            if (expressionValue != null && expressionValue.booleanValue()) continue;
            this.log.debug("Method: '{}' constrain '{}' evaluation is null or false!", (Object)ctx.getMethod(), (Object)constraint);
            throw new SecurityEvaluationException();
        }
        return ctx.proceed();
    }

    private Map<String, Object> computeParameterValues(InvocationContext ctx) {
        Annotation[][] parametersAnnotations = ctx.getMethod().getParameterAnnotations();
        HashMap<String, Object> secureVariables = new HashMap<String, Object>();
        for (int i = 0; i < parametersAnnotations.length; ++i) {
            Annotation[] parameterAnnotations;
            for (Annotation parameterAnnotation : parameterAnnotations = parametersAnnotations[i]) {
                if (!SecureVariable.class.isAssignableFrom(parameterAnnotation.annotationType())) continue;
                SecureVariable secureVariable = (SecureVariable)parameterAnnotation;
                Object paramValue = ctx.getParameters()[i];
                secureVariables.put(secureVariable.value(), paramValue);
            }
        }
        return secureVariables;
    }
}

