/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.script;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.conf.CustomScriptConfiguration;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.model.custom.script.type.BaseExternalType;
import org.gluu.service.custom.inject.ReloadScript;
import org.gluu.service.custom.script.CustomScriptManager;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

public class ExternalScriptService
implements Serializable {
    private static final long serialVersionUID = -1070021905117441202L;
    @Inject
    protected Logger log;
    @Inject
    protected CustomScriptManager customScriptManager;
    protected CustomScriptType customScriptType;
    protected Map<String, CustomScriptConfiguration> customScriptConfigurationsNameMap;
    protected List<CustomScriptConfiguration> customScriptConfigurations;
    protected CustomScriptConfiguration defaultExternalCustomScript;

    public ExternalScriptService(CustomScriptType customScriptType) {
        this.customScriptType = customScriptType;
    }

    public void reload(@Observes @ReloadScript String event) {
        List<CustomScriptConfiguration> newCustomScriptConfigurations = this.customScriptManager.getCustomScriptConfigurationsByScriptType(this.customScriptType);
        this.addExternalConfigurations(newCustomScriptConfigurations);
        this.customScriptConfigurations = newCustomScriptConfigurations;
        this.customScriptConfigurationsNameMap = this.buildExternalConfigurationsNameMap(this.customScriptConfigurations);
        this.defaultExternalCustomScript = this.determineDefaultCustomScriptConfiguration(this.customScriptConfigurations);
        this.reloadExternal();
    }

    protected void addExternalConfigurations(List<CustomScriptConfiguration> newCustomScriptConfigurations) {
    }

    protected void reloadExternal() {
    }

    private Map<String, CustomScriptConfiguration> buildExternalConfigurationsNameMap(List<CustomScriptConfiguration> customScriptConfigurations) {
        HashMap<String, CustomScriptConfiguration> reloadedExternalConfigurations = new HashMap<String, CustomScriptConfiguration>(customScriptConfigurations.size());
        for (CustomScriptConfiguration customScriptConfiguration : customScriptConfigurations) {
            reloadedExternalConfigurations.put(StringHelper.toLowerCase((String)customScriptConfiguration.getName()), customScriptConfiguration);
        }
        return reloadedExternalConfigurations;
    }

    public CustomScriptConfiguration determineDefaultCustomScriptConfiguration(List<CustomScriptConfiguration> customScriptConfigurations) {
        CustomScriptConfiguration defaultExternalCustomScript = null;
        for (CustomScriptConfiguration customScriptConfiguration : this.customScriptConfigurations) {
            if (defaultExternalCustomScript != null && defaultExternalCustomScript.getLevel() >= customScriptConfiguration.getLevel()) continue;
            defaultExternalCustomScript = customScriptConfiguration;
        }
        return defaultExternalCustomScript;
    }

    public int executeExternalGetApiVersion(CustomScriptConfiguration customScriptConfiguration) {
        try {
            this.log.debug("Executing python 'getApiVersion' authenticator method");
            BaseExternalType externalAuthenticator = customScriptConfiguration.getExternalType();
            return externalAuthenticator.getApiVersion();
        }
        catch (Exception ex) {
            this.log.error(ex.getMessage(), (Throwable)ex);
            this.saveScriptError(customScriptConfiguration.getCustomScript(), ex);
            return -1;
        }
    }

    public void saveScriptError(CustomScript customScript, Exception exception) {
        this.customScriptManager.saveScriptError(customScript, exception);
    }

    public void clearScriptError(CustomScript customScript) {
        this.customScriptManager.clearScriptError(customScript);
    }

    public boolean isEnabled() {
        if (this.customScriptConfigurations == null) {
            return false;
        }
        return this.customScriptConfigurations.size() > 0;
    }

    public CustomScriptConfiguration getCustomScriptConfigurationByName(String name) {
        return this.customScriptConfigurationsNameMap.get(StringHelper.toLowerCase((String)name));
    }

    public CustomScriptConfiguration getDefaultExternalCustomScript() {
        return this.defaultExternalCustomScript;
    }

    public List<CustomScriptConfiguration> getCustomScriptConfigurations() {
        return this.customScriptConfigurations;
    }
}

