/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.custom.script;

import com.google.common.base.Optional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gluu.model.custom.script.CustomScriptType;
import org.gluu.model.custom.script.model.CustomScript;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.slf4j.Logger;

public abstract class AbstractCustomScriptService
implements Serializable {
    private static final long serialVersionUID = -6187179012715072064L;
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;

    public void add(CustomScript customScript) {
        this.ldapEntryManager.persist((Object)customScript);
    }

    public void update(CustomScript customScript) {
        this.ldapEntryManager.merge((Object)customScript);
    }

    public void remove(CustomScript customScript) {
        this.ldapEntryManager.remove((Object)customScript);
    }

    public CustomScript getCustomScriptByDn(String customScriptDn, String ... returnAttributes) {
        return (CustomScript)((Object)this.ldapEntryManager.find((Object)customScriptDn, CustomScript.class, returnAttributes));
    }

    public CustomScript getCustomScriptByDn(Class<?> customScriptType, String customScriptDn) {
        return (CustomScript)((Object)this.ldapEntryManager.find(customScriptType, (Object)customScriptDn));
    }

    public Optional<CustomScript> getCustomScriptByINum(String baseDn, String inum, String ... returnAttributes) {
        ArrayList<Filter> customScriptTypeFilters = new ArrayList<Filter>();
        Filter customScriptTypeFilter = Filter.createEqualityFilter((String)"inum", (Object)inum);
        customScriptTypeFilters.add(customScriptTypeFilter);
        Filter filter = Filter.createORFilter(customScriptTypeFilters);
        List result = this.ldapEntryManager.findEntries(baseDn, CustomScript.class, filter, returnAttributes);
        if (result.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of(result.get(0));
    }

    public List<CustomScript> findAllCustomScripts(String[] returnAttributes) {
        String baseDn = this.baseDn();
        List result = this.ldapEntryManager.findEntries(baseDn, CustomScript.class, null, returnAttributes);
        return result;
    }

    public List<CustomScript> findCustomScripts(List<CustomScriptType> customScriptTypes, String ... returnAttributes) {
        String baseDn = this.baseDn();
        if (customScriptTypes == null || customScriptTypes.size() == 0) {
            return this.findAllCustomScripts(returnAttributes);
        }
        ArrayList<Filter> customScriptTypeFilters = new ArrayList<Filter>();
        for (CustomScriptType customScriptType : customScriptTypes) {
            Filter customScriptTypeFilter = Filter.createEqualityFilter((String)"oxScriptType", (Object)customScriptType.getValue());
            customScriptTypeFilters.add(customScriptTypeFilter);
        }
        Filter filter = Filter.createORFilter(customScriptTypeFilters);
        List result = this.ldapEntryManager.findEntries(baseDn, CustomScript.class, filter, returnAttributes);
        return result;
    }

    public String buildDn(String customScriptId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", customScriptId));
        dn.append(this.baseDn());
        return dn.toString();
    }

    public abstract String baseDn();
}

