/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cdi.async;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.gluu.service.cdi.async.Asynchronous;

@Interceptor
@Asynchronous
@Priority(value=0)
public class AsynchronousInterceptor
implements Serializable {
    private static final long serialVersionUID = 4839412676894893540L;
    private static final ThreadLocal<Boolean> ASYNC_INVOCATION = new ThreadLocal();

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        if (Boolean.TRUE.equals(ASYNC_INVOCATION.get())) {
            return ctx.proceed();
        }
        final InvocationContext localCtx = ctx;
        return CompletableFuture.supplyAsync(new Supplier<Object>(){

            @Override
            public Object get() {
                try {
                    ASYNC_INVOCATION.set(Boolean.TRUE);
                    Object object = localCtx.proceed();
                    return object;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    ASYNC_INVOCATION.remove();
                }
                return null;
            }
        });
    }
}

