/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gluu.service.cache.AbstractRedisProvider;
import org.gluu.service.cache.RedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;

public class RedisSentinelProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisSentinelProvider.class);
    private JedisSentinelPool pool;

    public RedisSentinelProvider(RedisConfiguration redisConfiguration) {
        super(redisConfiguration);
    }

    @Override
    public void create() {
        try {
            LOG.debug("Starting RedisSentinelProvider ... configuration:" + this.getRedisConfiguration());
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(1000);
            poolConfig.setMinIdle(2);
            this.pool = StringUtils.isBlank((String)this.redisConfiguration.getDecryptedPassword()) ? new JedisSentinelPool(this.getRedisConfiguration().getSentinelMasterGroupName(), (Set)Sets.newHashSet((Object[])StringUtils.split((String)this.getRedisConfiguration().getServers().trim(), (String)",")), (GenericObjectPoolConfig)poolConfig) : new JedisSentinelPool(this.getRedisConfiguration().getSentinelMasterGroupName(), (Set)Sets.newHashSet((Object[])StringUtils.split((String)this.getRedisConfiguration().getServers().trim(), (String)",")), (GenericObjectPoolConfig)poolConfig, this.redisConfiguration.getDecryptedPassword());
            this.testConnection();
            LOG.debug("RedisSentinelProvider started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start RedisSentinelProvider.");
            throw new IllegalStateException("Error starting RedisSentinelProvider", e);
        }
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying RedisSentinelProvider");
        try {
            this.pool.close();
        }
        catch (Exception e) {
            LOG.error("Failed to destroy RedisSentinelProvider", (Throwable)e);
            return;
        }
        LOG.debug("Destroyed RedisSentinelProvider");
    }

    public JedisSentinelPool getDelegate() {
        return this.pool;
    }

    @Override
    public Object get(String key) {
        byte[] value = this.pool.getResource().get(key.getBytes());
        Object deserialized = null;
        if (value != null && value.length > 0) {
            deserialized = SerializationUtils.deserialize((byte[])value);
        }
        return deserialized;
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        String status = this.pool.getResource().setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
        LOG.trace("put - key: " + key + ", status: " + status);
    }

    @Override
    public void put(String key, Object object) {
        String status = this.pool.getResource().set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
        LOG.trace("put - key: " + key + ", status: " + status);
    }

    @Override
    public void remove(String key) {
        Long entriesRemoved = this.pool.getResource().del(key.getBytes());
        LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
    }

    @Override
    public void clear() {
        try (Jedis jedis = this.pool.getResource();){
            jedis.flushAll();
            LOG.trace("clear");
        }
    }
}

