/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gluu.service.cache.AbstractCacheProvider;
import org.gluu.service.cache.AbstractRedisProvider;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.CacheProviderType;
import org.gluu.service.cache.RedisConfiguration;
import org.gluu.service.cache.RedisProviderFactory;
import org.gluu.util.security.StringEncrypter;
import org.slf4j.Logger;

@ApplicationScoped
public class RedisProvider
extends AbstractCacheProvider<AbstractRedisProvider> {
    public static final int DEFAULT_PUT_EXPIRATION_IN_SECONDS = 60;
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    private StringEncrypter stringEncrypter;
    private AbstractRedisProvider redisProvider;
    private int defaultPutExpiration = 60;

    @PostConstruct
    public void init() {
    }

    @Override
    public void create() {
        try {
            RedisConfiguration redisConfiguration = this.cacheConfiguration.getRedisConfiguration();
            this.decryptPassword(redisConfiguration);
            this.log.debug("Starting RedisProvider ... configuration:" + redisConfiguration);
            this.defaultPutExpiration = redisConfiguration.getDefaultPutExpiration() > 0 ? redisConfiguration.getDefaultPutExpiration() : 60;
            this.redisProvider = RedisProviderFactory.create(this.cacheConfiguration.getRedisConfiguration());
            this.redisProvider.create();
            this.log.debug("RedisProvider started.");
        }
        catch (Exception e) {
            this.log.error("Failed to start RedisProvider.");
            throw new IllegalStateException("Error starting RedisProvider", e);
        }
    }

    private void decryptPassword(RedisConfiguration redisConfiguration) {
        try {
            String encryptedPassword = redisConfiguration.getPassword();
            if (StringUtils.isNotBlank((String)encryptedPassword)) {
                redisConfiguration.setDecryptedPassword(this.stringEncrypter.decrypt(encryptedPassword));
                this.log.trace("Decrypted redis password successfully.");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            this.log.error("Error during redis password decryption", (Throwable)e);
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying RedisProvider");
        this.redisProvider.destroy();
        this.log.debug("Destroyed RedisProvider");
    }

    @Override
    public AbstractRedisProvider getDelegate() {
        return this.redisProvider;
    }

    @Override
    public Object get(String key) {
        if (key == null) {
            return null;
        }
        return this.redisProvider.get(key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        this.redisProvider.put(expirationInSeconds > 0 ? expirationInSeconds : this.defaultPutExpiration, key, object);
    }

    @Override
    public void remove(String key) {
        this.redisProvider.remove(key);
    }

    @Override
    public void clear() {
        this.redisProvider.clear();
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.REDIS;
    }
}

