/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.gluu.service.cache.AbstractRedisProvider;
import org.gluu.service.cache.RedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPoolConfig;

public class RedisClusterProvider
extends AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(RedisClusterProvider.class);
    private JedisCluster pool;

    public RedisClusterProvider(RedisConfiguration redisConfiguration) {
        super(redisConfiguration);
    }

    @Override
    public void create() {
        try {
            LOG.debug("Starting RedisClusterProvider ... configuration:" + this.getRedisConfiguration());
            JedisPoolConfig poolConfig = new JedisPoolConfig();
            poolConfig.setMaxTotal(1000);
            poolConfig.setMinIdle(2);
            this.pool = StringUtils.isBlank((String)this.redisConfiguration.getDecryptedPassword()) ? new JedisCluster(RedisClusterProvider.hosts(this.getRedisConfiguration().getServers()), (GenericObjectPoolConfig)poolConfig) : new JedisCluster(RedisClusterProvider.hosts(this.getRedisConfiguration().getServers()), 2000, 2000, 5, this.redisConfiguration.getDecryptedPassword(), (GenericObjectPoolConfig)poolConfig);
            this.testConnection();
            LOG.debug("RedisClusterProvider started.");
        }
        catch (Exception e) {
            LOG.error("Failed to start RedisClusterProvider.");
            throw new IllegalStateException("Error starting RedisClusterProvider", e);
        }
    }

    public static Set<HostAndPort> hosts(String servers) {
        String[] serverWithPorts = StringUtils.split((String)servers.trim(), (String)",");
        HashSet<HostAndPort> set = new HashSet<HostAndPort>();
        for (String serverWithPort : serverWithPorts) {
            String[] split = serverWithPort.trim().split(":");
            String host = split[0];
            int port = Integer.parseInt(split[1].trim());
            set.add(new HostAndPort(host, port));
        }
        return set;
    }

    @Override
    public void destroy() {
        LOG.debug("Destroying RedisClusterProvider");
        try {
            this.pool.close();
        }
        catch (IOException e) {
            LOG.error("Failed to destroy RedisClusterProvider", (Throwable)e);
            return;
        }
        LOG.debug("Destroyed RedisClusterProvider");
    }

    public JedisCluster getDelegate() {
        return this.pool;
    }

    @Override
    public Object get(String key) {
        byte[] value = this.pool.get(key.getBytes());
        Object deserialized = null;
        if (value != null && value.length > 0) {
            deserialized = SerializationUtils.deserialize((byte[])value);
        }
        return deserialized;
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        String status = this.pool.setex(key.getBytes(), expirationInSeconds, SerializationUtils.serialize((Serializable)((Serializable)object)));
        LOG.trace("put - key: " + key + ", status: " + status);
    }

    @Override
    public void put(String key, Object object) {
        String status = this.pool.set(key.getBytes(), SerializationUtils.serialize((Serializable)((Serializable)object)));
        LOG.trace("put - key: " + key + ", status: " + status);
    }

    @Override
    public void remove(String key) {
        Long entriesRemoved = this.pool.del(key.getBytes());
        LOG.trace("remove - key: " + key + ", entriesRemoved: " + entriesRemoved);
    }

    @Override
    public void clear() {
        LOG.trace("clear not allowed for cluster deployments");
    }
}

