/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.model.base.SimpleBranch;
import org.gluu.search.filter.Filter;
import org.gluu.service.cache.AbstractCacheProvider;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.CacheProviderType;
import org.gluu.service.cache.NativePersistenceCacheEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class NativePersistenceCacheProvider
extends AbstractCacheProvider<PersistenceEntryManager> {
    private static final Logger log = LoggerFactory.getLogger(NativePersistenceCacheProvider.class);
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    private PersistenceEntryManager entryManager;
    private String baseDn;
    private boolean deleteExpiredOnGetRequest;

    @Override
    public void create() {
        try {
            this.baseDn = this.cacheConfiguration.getNativePersistenceConfiguration().getBaseDn();
            this.deleteExpiredOnGetRequest = this.cacheConfiguration.getNativePersistenceConfiguration().isDeleteExpiredOnGetRequest();
            if (StringUtils.isBlank((String)this.baseDn)) {
                log.error("Failed to create NATIVE_PERSISTENCE cache provider. 'baseDn' in LdapCacheConfiguration is not initialized. It has to be set by client application (e.g. oxAuth has to set it in ApplicationFactory.)");
                throw new RuntimeException("Failed to create NATIVE_PERSISTENCE cache provider. 'baseDn' in LdapCacheConfiguration is not initialized. It has to be set by client application.");
            }
            String branchDn = String.format("ou=cache,%s", this.baseDn);
            if (this.entryManager.hasBranchesSupport(branchDn) && !this.entryManager.contains(branchDn, SimpleBranch.class)) {
                SimpleBranch branch = new SimpleBranch();
                branch.setOrganizationalUnitName("cache");
                branch.setDn(branchDn);
                this.entryManager.persist((Object)branch);
            }
            this.baseDn = branchDn;
            this.cacheConfiguration.getNativePersistenceConfiguration().setBaseDn(this.baseDn);
            log.info("Created NATIVE_PERSISTENCE cache provider. `baseDn`: " + this.baseDn);
        }
        catch (Exception e) {
            log.error("Failed to create NATIVE_PERSISTENCE cache provider.", (Throwable)e);
            throw new RuntimeException("Failed to create NATIVE_PERSISTENCE cache provider.", e);
        }
    }

    @Override
    public void destroy() {
    }

    @Override
    public PersistenceEntryManager getDelegate() {
        return this.entryManager;
    }

    @Override
    public Object get(String key) {
        try {
            key = NativePersistenceCacheProvider.hashKey(key);
            NativePersistenceCacheEntity entity = (NativePersistenceCacheEntity)this.entryManager.find(NativePersistenceCacheEntity.class, (Object)this.createDn(key));
            if (entity != null && entity.getData() != null) {
                if (NativePersistenceCacheProvider.isExpired(entity.getNewExpirationDate()) && entity.isDeletable()) {
                    log.trace("Cache entity exists but expired, return null, expirationDate:" + entity.getExpirationDate() + ", key: " + key);
                    if (this.deleteExpiredOnGetRequest) {
                        this.remove(key);
                    }
                    return null;
                }
                Object o = NativePersistenceCacheProvider.fromString(entity.getData());
                return o;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String createDn(String key) {
        return String.format("uuid=%s,%s", key, this.baseDn);
    }

    public static String hashKey(String key) {
        return DigestUtils.sha256Hex((String)key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        String originalKey = key;
        try {
            key = NativePersistenceCacheProvider.hashKey(key);
            Date creationDate = new Date();
            expirationInSeconds = expirationInSeconds > 0 ? expirationInSeconds : this.cacheConfiguration.getNativePersistenceConfiguration().getDefaultPutExpiration();
            Calendar expirationDate = Calendar.getInstance();
            expirationDate.setTime(creationDate);
            expirationDate.add(13, expirationInSeconds);
            NativePersistenceCacheEntity entity = new NativePersistenceCacheEntity();
            entity.setData(NativePersistenceCacheProvider.asString(object));
            entity.setId(key);
            entity.setDn(this.createDn(key));
            entity.setCreationDate(creationDate);
            entity.setNewExpirationDate(expirationDate.getTime());
            entity.setDeletable(true);
            this.silentlyRemoveEntityIfExists(entity.getDn());
            this.entryManager.persist((Object)entity);
        }
        catch (Exception e) {
            log.error("Failed to put entry, key: " + originalKey + ", hashedKey: " + key + ", message: " + e.getMessage(), (Throwable)e);
        }
    }

    private boolean silentlyRemoveEntityIfExists(String dn) {
        try {
            if (this.entryManager.find(NativePersistenceCacheEntity.class, (Object)dn) != null) {
                this.entryManager.remove(dn);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean isExpired(Date expiredAt) {
        return expiredAt == null || expiredAt.before(new Date());
    }

    @Override
    public void remove(String key) {
        if (this.silentlyRemoveEntityIfExists(this.createDn(NativePersistenceCacheProvider.hashKey(key)))) {
            log.trace("Removed entity, key: " + key);
        }
    }

    @Override
    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object fromString(String s) {
        Object object;
        byte[] data = Base64.decodeBase64((String)s);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        try {
            Object o = ois.readObject();
            ois.close();
            object = o;
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)ois);
                throw throwable;
            }
            catch (Exception e) {
                log.error("Failed to deserizalize cache entity, data: " + s);
                return null;
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String asString(Object o) {
        String string;
        ObjectOutputStream oos = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
            string = Base64.encodeBase64String((byte[])baos.toByteArray());
        }
        catch (Exception e) {
            String string2;
            try {
                log.error("Failed to serizalize cache entity to string, object: 0");
                string2 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)oos);
            return string2;
        }
        IOUtils.closeQuietly((OutputStream)oos);
        return string;
    }

    @Override
    public void cleanup(Date now) {
        this.cleanup(now, this.cacheConfiguration.getNativePersistenceConfiguration().getDefaultCleanupBatchSize());
    }

    public void cleanup(Date now, int batchSize) {
        log.debug("Start NATIVE_PERSISTENCE clean up");
        try {
            Filter filter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createEqualityFilter((String)"del", (Object)true), Filter.createLessOrEqualFilter((String)"exp", (Object)this.entryManager.encodeTime(this.baseDn, now))});
            int removedCount = this.entryManager.remove(this.baseDn, NativePersistenceCacheEntity.class, filter, batchSize);
            log.debug("End NATIVE_PERSISTENCE clean up, items removed: " + removedCount);
        }
        catch (Exception e) {
            log.error("Failed to perform clean up.", (Throwable)e);
        }
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.NATIVE_PERSISTENCE;
    }

    public void setEntryManager(PersistenceEntryManager entryManager) {
        this.entryManager = entryManager;
    }

    public void setBaseDn(String baseDn) {
        this.baseDn = baseDn;
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }
}

