/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;
import org.gluu.service.cache.AbstractCacheProvider;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.CacheProviderType;
import org.gluu.service.cache.InMemoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class InMemoryCacheProvider
extends AbstractCacheProvider<ExpiringMap> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryCacheProvider.class);
    @Inject
    private CacheConfiguration cacheConfiguration;
    private ExpiringMap<String, Object> map = ExpiringMap.builder().build();
    private InMemoryConfiguration inMemoryConfiguration;

    @PostConstruct
    public void init() {
        this.inMemoryConfiguration = this.cacheConfiguration.getInMemoryConfiguration();
    }

    @Override
    public void create() {
        LOG.debug("Starting InMemoryCacheProvider ...");
        try {
            this.map = ExpiringMap.builder().expirationPolicy(ExpirationPolicy.CREATED).variableExpiration().build();
            LOG.debug("InMemoryCacheProvider started.");
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting InMemoryCacheProvider", e);
        }
    }

    @Override
    @PreDestroy
    public void destroy() {
        LOG.debug("Destroying InMemoryCacheProvider");
        this.map.clear();
        LOG.debug("Destroyed InMemoryCacheProvider");
    }

    @Override
    public ExpiringMap getDelegate() {
        return this.map;
    }

    @Override
    public Object get(String key) {
        return this.map.get((Object)key);
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        this.map.remove((Object)key);
        expirationInSeconds = expirationInSeconds >= 0 ? expirationInSeconds : this.inMemoryConfiguration.getDefaultPutExpiration();
        this.map.put((Object)key, object, ExpirationPolicy.CREATED, (long)expirationInSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void remove(String key) {
        this.map.remove((Object)key);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void setCacheConfiguration(CacheConfiguration cacheConfiguration) {
        this.cacheConfiguration = cacheConfiguration;
    }

    @Override
    public CacheProviderType getProviderType() {
        return CacheProviderType.IN_MEMORY;
    }
}

