/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.service.cache.AbstractCacheProvider;
import org.gluu.service.cache.CacheConfiguration;
import org.gluu.service.cache.CacheProvider;
import org.gluu.service.cache.CacheProviderType;
import org.gluu.service.cache.InMemoryCacheProvider;
import org.gluu.service.cache.LocalCache;
import org.gluu.service.cache.MemcachedProvider;
import org.gluu.service.cache.NativePersistenceCacheProvider;
import org.gluu.service.cache.RedisProvider;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class CacheProviderFactory {
    @Inject
    private Logger log;
    @Inject
    private CacheConfiguration cacheConfiguration;
    @Inject
    @Any
    private Instance<CacheProvider> instance;

    @Produces
    @ApplicationScoped
    public CacheProvider getCacheProvider() {
        this.log.debug("Started to create cache provider");
        return this.getCacheProvider(this.cacheConfiguration);
    }

    public CacheProvider getCacheProvider(CacheConfiguration cacheConfiguration) {
        CacheProviderType cacheProviderType = cacheConfiguration.getCacheProviderType();
        if (cacheProviderType == null) {
            this.log.error("Failed to initialize cacheProvider, cacheProviderType is null. Fallback to IN_MEMORY type.");
            cacheProviderType = CacheProviderType.IN_MEMORY;
        }
        AbstractCacheProvider cacheProvider = null;
        switch (cacheProviderType) {
            case IN_MEMORY: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(InMemoryCacheProvider.class, new Annotation[0]).get();
                break;
            }
            case MEMCACHED: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(MemcachedProvider.class, new Annotation[0]).get();
                break;
            }
            case REDIS: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(RedisProvider.class, new Annotation[0]).get();
                break;
            }
            case NATIVE_PERSISTENCE: {
                cacheProvider = (AbstractCacheProvider)this.instance.select(NativePersistenceCacheProvider.class, new Annotation[0]).get();
            }
        }
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + (Object)((Object)cacheProviderType));
        }
        cacheProvider.create();
        return cacheProvider;
    }

    @Produces
    @ApplicationScoped
    @LocalCache
    public CacheProvider getLocalCacheProvider() {
        this.log.debug("Started to create local cache provider");
        CacheProviderType cacheProviderType = CacheProviderType.IN_MEMORY;
        AbstractCacheProvider cacheProvider = (AbstractCacheProvider)this.instance.select(InMemoryCacheProvider.class, new Annotation[0]).get();
        if (cacheProvider == null) {
            throw new RuntimeException("Failed to initialize cacheProvider, cacheProviderType is unsupported: " + (Object)((Object)cacheProviderType));
        }
        cacheProvider.create();
        return cacheProvider;
    }
}

