/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service.cache;

import org.gluu.service.cache.RedisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRedisProvider.class);
    protected RedisConfiguration redisConfiguration;

    public AbstractRedisProvider(RedisConfiguration redisConfiguration) {
        this.redisConfiguration = redisConfiguration;
    }

    public RedisConfiguration getRedisConfiguration() {
        return this.redisConfiguration;
    }

    public void testConnection() {
        this.put(2, "testKey", "testValue");
        if (!"testValue".equals(this.get("testKey"))) {
            throw new RuntimeException("Failed to connect to redis server. Configuration: " + this.redisConfiguration);
        }
    }

    public boolean isConnected() {
        this.put(2, "testKey", "testValue");
        return "testValue".equals(this.get("testKey"));
    }

    public abstract void create();

    public abstract void destroy();

    public abstract Object getDelegate();

    public abstract Object get(String var1);

    public abstract void remove(String var1);

    public abstract void clear();

    public abstract void put(int var1, String var2, Object var3);

    public abstract void put(String var1, Object var2);
}

