/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.IOUtils;
import org.gluu.model.GluuImage;
import org.gluu.model.TrustContact;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@ApplicationScoped
@Named
public class XmlService
implements Serializable {
    private static final long serialVersionUID = -4805285557592935972L;
    @Inject
    private Logger log;
    private JAXBContext jaxbContext;
    private Marshaller jaxbMarshaller;
    private Unmarshaller jaxbUnmarshaller;

    @PostConstruct
    public void init() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{GluuImage.class, TrustContact.class});
            this.jaxbMarshaller = this.jaxbContext.createMarshaller();
            this.jaxbUnmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException ex) {
            this.log.error("Failed to create JAXB marshaller and unmarshaller", (Throwable)ex);
        }
    }

    public String getXMLFromGluuImage(GluuImage photo) {
        if (photo == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.jaxbMarshaller.marshal((Object)photo, (OutputStream)bos);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            this.log.error("Failed to convert GluuImage {} to XML", (Object)ex, (Object)photo);
            return null;
        }
    }

    public GluuImage getGluuImageFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            return (GluuImage)this.jaxbUnmarshaller.unmarshal((InputStream)bis);
        }
        catch (Exception ex) {
            this.log.error("Failed to create GluuImage from XML {}", (Object)ex, (Object)xml);
            return null;
        }
    }

    public TrustContact getTrustContactFromXML(String xml) {
        if (xml == null) {
            return null;
        }
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            return (TrustContact)this.jaxbUnmarshaller.unmarshal((InputStream)bis);
        }
        catch (Exception ex) {
            this.log.error("Failed to create TrustContact from XML {}", (Object)ex, (Object)xml);
            return null;
        }
    }

    public String getXMLFromTrustContact(TrustContact contact) {
        if (contact == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.jaxbMarshaller.marshal((Object)contact, (OutputStream)bos);
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (Exception ex) {
            this.log.error("Failed to convert TrustContact {} to XML", (Object)ex, (Object)contact);
            return null;
        }
    }

    public Document getXmlDocument(byte[] xmlDocumentBytes) throws SAXException, IOException, ParserConfigurationException {
        return this.getXmlDocument(xmlDocumentBytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getXmlDocument(byte[] xmlDocumentBytes, boolean skipValidation) throws SAXException, IOException, ParserConfigurationException {
        ByteArrayInputStream bis = new ByteArrayInputStream(xmlDocumentBytes);
        try {
            DocumentBuilderFactory fty = this.createDocumentBuilderFactory(skipValidation);
            Document document = fty.newDocumentBuilder().parse(bis);
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public Document getXmlDocument(InputStream is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(is);
    }

    public Document getXmlDocument(InputSource is) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(is);
    }

    public Document getXmlDocument(String uri) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory fty = this.createDocumentBuilderFactory();
        return fty.newDocumentBuilder().parse(uri);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        return this.createDocumentBuilderFactory(false);
    }

    private DocumentBuilderFactory createDocumentBuilderFactory(boolean skipValidation) throws ParserConfigurationException {
        DocumentBuilderFactory fty = DocumentBuilderFactory.newInstance();
        if (skipValidation) {
            return fty;
        }
        fty.setNamespaceAware(true);
        fty.setXIncludeAware(false);
        fty.setExpandEntityReferences(false);
        fty.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        fty.setFeature("http://xml.org/sax/features/external-general-entities", false);
        fty.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        return fty;
    }

    public String getNodeValue(Document xmlDocument, String xPathExpression, String attributeName) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        XPathExpression formXPathExpression = xPath.compile(xPathExpression);
        if (StringHelper.isEmpty((String)attributeName)) {
            String nodeValue = (String)formXPathExpression.evaluate(xmlDocument, XPathConstants.STRING);
            return nodeValue;
        }
        Node node = (Node)formXPathExpression.evaluate(xmlDocument, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        Node attributeNode = node.getAttributes().getNamedItem(attributeName);
        if (attributeNode == null) {
            return null;
        }
        return attributeNode.getNodeValue();
    }
}

