/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.ObjectClassDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.model.SchemaEntry;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.ldap.operation.LdapOperationService;
import org.gluu.util.StringHelper;
import org.gluu.util.exception.InvalidSchemaUpdateException;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class SchemaService {
    @Inject
    private Logger log;
    @Inject
    private PersistenceEntryManager ldapEntryManager;

    public SchemaEntry getSchema() {
        String shemaDn = this.getDnForSchema();
        if (StringHelper.isNotEmpty((String)shemaDn)) {
            SchemaEntry schemaEntry = (SchemaEntry)this.ldapEntryManager.find((Object)this.getDnForSchema(), SchemaEntry.class, null);
            return schemaEntry;
        }
        return null;
    }

    public void addObjectClass(String objectClass, String attributeTypes, String schemaAddObjectClassWithoutAttributeTypesDefinition, String schemaAddObjectClassWithAttributeTypesDefinition) {
        SchemaEntry schemaEntry = new SchemaEntry();
        schemaEntry.setDn(this.getDnForSchema());
        String objectClassDefinition = StringHelper.isEmpty((String)attributeTypes) ? String.format(schemaAddObjectClassWithoutAttributeTypesDefinition, objectClass, objectClass) : String.format(schemaAddObjectClassWithAttributeTypesDefinition, objectClass, objectClass, attributeTypes);
        schemaEntry.addObjectClass(objectClassDefinition);
        this.log.debug("Adding new objectClass: {}", (Object)schemaEntry);
        this.ldapEntryManager.merge((Object)schemaEntry);
    }

    public void removeObjectClass(String objectClass) {
        SchemaEntry schema = this.getSchema();
        String objectClassDefinition = this.getObjectClassDefinition(schema, objectClass);
        if (objectClassDefinition != null) {
            this.removeObjectClassWithDefinition(objectClassDefinition);
        }
    }

    private void removeObjectClassWithDefinition(String objectClassDefinition) {
        SchemaEntry schemaEntry = new SchemaEntry();
        schemaEntry.setDn(this.getDnForSchema());
        schemaEntry.addObjectClass(objectClassDefinition);
        this.log.debug("Removing objectClass: {}", (Object)schemaEntry);
        this.ldapEntryManager.remove((Object)schemaEntry);
    }

    public void addAttributeTypeToObjectClass(String objectClass, String attributeType) throws Exception {
        int index2;
        SchemaEntry schema = this.getSchema();
        String objectClassDefinition = this.getObjectClassDefinition(schema, objectClass);
        if (objectClassDefinition == null) {
            throw new InvalidSchemaUpdateException(String.format("Can't add attributeType %s to objectClass %s because objectClass doesn't exist", attributeType, objectClass));
        }
        String newObjectClassDefinition = null;
        String attributeTypesStartPattern = "MAY ( ";
        int index = objectClassDefinition.indexOf(attributeTypesStartPattern);
        if (index != -1) {
            index2 = objectClassDefinition.indexOf(")", index);
            newObjectClassDefinition = objectClassDefinition.substring(0, index2) + "$ " + attributeType + " " + objectClassDefinition.substring(index2);
        } else {
            attributeTypesStartPattern = "MUST objectClass ";
            index = objectClassDefinition.indexOf(attributeTypesStartPattern);
            if (index != -1) {
                index2 = index + attributeTypesStartPattern.length();
                newObjectClassDefinition = objectClassDefinition.substring(0, index2) + "MAY ( " + attributeType + " ) " + objectClassDefinition.substring(index2);
            }
        }
        this.log.debug("Current object class definition:" + objectClassDefinition);
        this.log.debug("New object class definition:" + newObjectClassDefinition);
        if (newObjectClassDefinition == null) {
            throw new InvalidSchemaUpdateException(String.format("Invalid objectClass definition format", new Object[0]));
        }
        this.removeObjectClassWithDefinition(objectClassDefinition);
        SchemaEntry newSchemaEntry = new SchemaEntry();
        newSchemaEntry.setDn(this.getDnForSchema());
        newSchemaEntry.addObjectClass(newObjectClassDefinition);
        this.log.debug("Adding attributeType to objectClass: {}", (Object)newSchemaEntry);
        this.ldapEntryManager.merge((Object)newSchemaEntry);
    }

    public void removeAttributeTypeFromObjectClass(String objectClass, String attributeType) throws Exception {
        SchemaEntry schema = this.getSchema();
        String objectClassDefinition = this.getObjectClassDefinition(schema, objectClass);
        if (objectClassDefinition == null) {
            throw new InvalidSchemaUpdateException(String.format("Can't add attributeType %s to objectClass %s because objectClass doesn't exist", attributeType, objectClass));
        }
        String attributeTypePattern = "$ " + attributeType + " ";
        int index = objectClassDefinition.indexOf(attributeTypePattern);
        if (index == -1 && (index = objectClassDefinition.indexOf(attributeTypePattern = " " + attributeType + " $")) == -1 && (index = objectClassDefinition.indexOf(attributeTypePattern = " MAY ( " + attributeType + " )")) == -1) {
            throw new InvalidSchemaUpdateException(String.format("Invalid objectClass definition format", new Object[0]));
        }
        String newObjectClassDefinition = objectClassDefinition.substring(0, index) + objectClassDefinition.substring(index + attributeTypePattern.length());
        this.removeObjectClassWithDefinition(objectClassDefinition);
        SchemaEntry schemaEntry = new SchemaEntry();
        schemaEntry.setDn(this.getDnForSchema());
        schemaEntry.addObjectClass(newObjectClassDefinition);
        this.log.debug("Removing attributeType from objectClass: {}", (Object)schemaEntry);
        this.ldapEntryManager.merge((Object)schemaEntry);
    }

    public void addStringAttribute(String oid, String name, String schemaAddAttributeDefinition) throws Exception {
        this.log.info("getting a new instance SchemaEntry ");
        SchemaEntry schemaEntry = new SchemaEntry();
        this.log.info("setting the DN ");
        schemaEntry.setDn(this.getDnForSchema());
        this.log.info("adding attribute name ");
        this.log.info("applicationConfiguration.getSchemaAddAttributeDefinition() : ", (Object)schemaAddAttributeDefinition);
        this.log.info("oid : ", (Object)oid);
        this.log.info("name : ", (Object)name);
        schemaEntry.addAttributeType(String.format(schemaAddAttributeDefinition, oid, name));
        this.log.debug("Adding new attributeType: {}", (Object)schemaEntry);
        this.log.info("merging data");
        this.ldapEntryManager.merge((Object)schemaEntry);
    }

    public void removeStringAttribute(String attributeType) throws Exception {
        SchemaEntry schema = this.getSchema();
        String attributeTypeDefinition = this.getAttributeTypeDefinition(schema, attributeType);
        if (attributeTypeDefinition != null) {
            SchemaEntry schemaEntry = new SchemaEntry();
            schemaEntry.setDn(this.getDnForSchema());
            schemaEntry.addAttributeType(attributeTypeDefinition);
            this.log.debug("Removing attributeType: {}", (Object)schemaEntry);
            this.ldapEntryManager.remove((Object)schemaEntry);
        }
    }

    public String getAttributeTypeDefinition(SchemaEntry schemaEntry, String attributeType) {
        if (schemaEntry == null || attributeType == null) {
            return null;
        }
        String lowerCaseAttributeType = StringHelper.toLowerCase((String)attributeType);
        List<AttributeTypeDefinition> attributeTypes = this.getAttributeTypeDefinitions(schemaEntry, Arrays.asList(lowerCaseAttributeType));
        AttributeTypeDefinition attributeTypeDefinition = this.getAttributeTypeDefinition(attributeTypes, lowerCaseAttributeType);
        return attributeTypeDefinition == null ? null : attributeTypeDefinition.toString();
    }

    public AttributeTypeDefinition getAttributeTypeDefinition(List<AttributeTypeDefinition> attributeTypes, String attributeType) {
        if (attributeTypes == null || attributeType == null) {
            return null;
        }
        for (AttributeTypeDefinition definition : attributeTypes) {
            for (String name : definition.getNames()) {
                if (!name.equalsIgnoreCase(attributeType)) continue;
                return definition;
            }
        }
        return null;
    }

    public List<AttributeTypeDefinition> getAttributeTypeDefinitions(SchemaEntry schemaEntry, List<String> attributeNames) {
        if (schemaEntry == null) {
            return null;
        }
        String[] attrs = attributeNames.toArray(new String[attributeNames.size()]);
        for (int i = 0; i < attrs.length; ++i) {
            attrs[i] = "'" + attrs[i].toLowerCase() + "'";
        }
        ArrayList<AttributeTypeDefinition> result = new ArrayList<AttributeTypeDefinition>();
        for (String attributeTypeDefinition : schemaEntry.getAttributeTypes()) {
            for (String name : attrs) {
                if (!attributeTypeDefinition.toLowerCase().contains(name)) continue;
                try {
                    result.add(new AttributeTypeDefinition(attributeTypeDefinition));
                }
                catch (Exception ex) {
                    this.log.error("Failed to get attribute type definition by string {}", (Object)ex, (Object)attributeTypeDefinition);
                }
            }
        }
        return result;
    }

    public String getObjectClassDefinition(SchemaEntry schemaEntry, String objectClass) {
        if (schemaEntry == null || objectClass == null) {
            return null;
        }
        for (String objectClassDefinition : schemaEntry.getObjectClasses()) {
            try {
                ObjectClassDefinition definition = new ObjectClassDefinition(objectClassDefinition);
                for (String name : definition.getNames()) {
                    if (!name.equalsIgnoreCase(objectClass)) continue;
                    return objectClassDefinition;
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Set<String> getObjectClassesAttributes(SchemaEntry schemaEntry, String[] objectClasses) {
        if (schemaEntry == null || objectClasses == null) {
            return null;
        }
        HashMap<String, ObjectClassDefinition> objectClassDefinitions = new HashMap<String, ObjectClassDefinition>();
        for (String objectClassDefinition : schemaEntry.getObjectClasses()) {
            try {
                ObjectClassDefinition definition = new ObjectClassDefinition(objectClassDefinition);
                for (String name : definition.getNames()) {
                    objectClassDefinitions.put(StringHelper.toLowerCase((String)name), definition);
                }
            }
            catch (Exception ex) {
                this.log.error("Failed to parse LDAP object class definition: '{}'", (Object)ex, (Object)objectClassDefinition);
            }
        }
        Set<ObjectClassDefinition> resultObjectClassDefinitions = this.getSuperiorClasses(objectClassDefinitions, objectClasses, true);
        Set<String> resultAttributes = this.getAttributes(resultObjectClassDefinitions, true, true);
        return resultAttributes;
    }

    private Set<String> getAttributes(Set<ObjectClassDefinition> objectClassDefinitions, boolean includeRequired, boolean includeOpional) {
        LinkedHashSet<String> resultAttributes = new LinkedHashSet<String>();
        for (ObjectClassDefinition objectClassDefinition : objectClassDefinitions) {
            if (includeRequired) {
                for (String attribute : objectClassDefinition.getRequiredAttributes()) {
                    resultAttributes.add(StringHelper.toLowerCase((String)attribute));
                }
            }
            if (!includeOpional) continue;
            for (String attribute : objectClassDefinition.getOptionalAttributes()) {
                resultAttributes.add(StringHelper.toLowerCase((String)attribute));
            }
        }
        return resultAttributes;
    }

    public Set<ObjectClassDefinition> getSuperiorClasses(Map<String, ObjectClassDefinition> objectClassDefinitions, String[] superiorClasses, boolean recursive) {
        LinkedHashSet<ObjectClassDefinition> resultObjectClassDefinitions = new LinkedHashSet<ObjectClassDefinition>();
        for (String superiorClass : superiorClasses) {
            ObjectClassDefinition objectClassDefinition = objectClassDefinitions.get(StringHelper.toLowerCase((String)superiorClass));
            if (objectClassDefinition == null) continue;
            resultObjectClassDefinitions.add(objectClassDefinition);
            if (!recursive) continue;
            SchemaService.getSuperiorClasses(objectClassDefinitions, objectClassDefinition, resultObjectClassDefinitions);
        }
        return Collections.unmodifiableSet(resultObjectClassDefinitions);
    }

    private static void getSuperiorClasses(Map<String, ObjectClassDefinition> objectClassDefinitions, ObjectClassDefinition objectClassDefinition, Set<ObjectClassDefinition> resultObjectClassDefinitions) {
        for (String superiorClass : objectClassDefinition.getSuperiorClasses()) {
            ObjectClassDefinition superiorObjectClassDefinition = objectClassDefinitions.get(StringHelper.toLowerCase((String)superiorClass));
            if (superiorObjectClassDefinition == null) continue;
            resultObjectClassDefinitions.add(superiorObjectClassDefinition);
            SchemaService.getSuperiorClasses(objectClassDefinitions, superiorObjectClassDefinition, resultObjectClassDefinitions);
        }
    }

    public boolean containsAttributeTypeInSchema(String attributeType) {
        SchemaEntry schema = this.getSchema();
        return this.getAttributeTypeDefinition(schema, attributeType) != null;
    }

    public Set<String> getObjectClassesByAttribute(SchemaEntry schemaEntry, String attributeType) {
        if (schemaEntry == null || StringHelper.isEmpty((String)attributeType)) {
            return null;
        }
        String lowerCaseAttributeType = StringHelper.toLowerCase((String)attributeType);
        HashSet<String> resultObjectClasses = new HashSet<String>();
        for (String objectClassDefinition : schemaEntry.getObjectClasses()) {
            try {
                ObjectClassDefinition definition = new ObjectClassDefinition(objectClassDefinition);
                HashSet<String> objectClassAttributeTypes = new HashSet<String>();
                for (String name : definition.getOptionalAttributes()) {
                    objectClassAttributeTypes.add(StringHelper.toLowerCase((String)name));
                }
                for (String name : definition.getRequiredAttributes()) {
                    objectClassAttributeTypes.add(StringHelper.toLowerCase((String)name));
                }
                if (!objectClassAttributeTypes.contains(lowerCaseAttributeType)) continue;
                String objectClassType = definition.getNameOrOID();
                resultObjectClasses.add(objectClassType);
            }
            catch (Exception ex) {
                this.log.error("Failed to parse LDAP object class definition: '{}'", (Object)ex, (Object)objectClassDefinition);
            }
        }
        return resultObjectClasses;
    }

    public String getDnForSchema() {
        if (this.ldapEntryManager.getOperationService() instanceof LdapOperationService) {
            return ((LdapOperationService)this.ldapEntryManager.getOperationService()).getSubschemaSubentry();
        }
        return "";
    }
}

