/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.gluu.exception.PythonException;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.util.StringHelper;
import org.python.core.PyException;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;

@ApplicationScoped
@Named
public class PythonService
implements Serializable {
    private static final long serialVersionUID = 3398422090669045605L;
    @Inject
    private Logger log;
    private PythonInterpreter pythonInterpreter;
    private boolean interpereterReady;
    private OutputStreamWriter logOut;
    private OutputStreamWriter logErr;

    @PostConstruct
    public void init() {
        try {
            this.logOut = new OutputStreamWriter((OutputStream)new PythonLoggerOutputStream(this.log, false), "UTF-8");
            this.logErr = new OutputStreamWriter((OutputStream)new PythonLoggerOutputStream(this.log, true), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Failed to initialize Jython out/err loggers", (Throwable)ex);
        }
    }

    public boolean initPythonInterpreter(String pythonModulesDir) {
        boolean result = false;
        if (this.isInitInterpreter()) {
            try {
                PythonInterpreter.initialize((Properties)this.getPreProperties(), (Properties)this.getPostProperties(pythonModulesDir), null);
                this.pythonInterpreter = new PythonInterpreter();
                this.initPythonInterpreter(this.pythonInterpreter);
                result = true;
            }
            catch (PyException ex) {
                this.log.error("Failed to initialize PythonInterpreter correctly", (Throwable)ex);
            }
            catch (Exception ex) {
                this.log.error("Failed to initialize PythonInterpreter correctly", (Throwable)ex);
            }
        }
        this.interpereterReady = result;
        return result;
    }

    private void initPythonInterpreter(PythonInterpreter interpreter) {
        if (this.logOut != null) {
            interpreter.setOut((Writer)this.logOut);
        }
        if (this.logErr != null) {
            interpreter.setErr((Writer)this.logErr);
        }
    }

    @PreDestroy
    public void destroy() {
        this.log.debug("Destroying pythonInterpreter component");
        if (this.pythonInterpreter != null) {
            this.pythonInterpreter.cleanup();
        }
    }

    private Properties getPreProperties() {
        Properties props = System.getProperties();
        Properties clonedProps = (Properties)props.clone();
        clonedProps.setProperty("java.class.path", ".");
        clonedProps.setProperty("java.library.path", "");
        clonedProps.remove("javax.net.ssl.trustStore");
        clonedProps.remove("javax.net.ssl.trustStorePassword");
        return clonedProps;
    }

    private Properties getPostProperties(String pythonModulesDir) {
        Properties props = this.getPreProperties();
        String catalinaTmpFolder = System.getProperty("java.io.tmpdir") + File.separator + "python" + File.separator + "cachedir";
        props.setProperty("python.cachedir", catalinaTmpFolder);
        String pythonHome = System.getenv("PYTHON_HOME");
        if (StringHelper.isNotEmpty((String)pythonHome)) {
            props.setProperty("python.home", pythonHome);
        }
        if (StringHelper.isNotEmpty((String)pythonModulesDir)) {
            props.setProperty("python.path", pythonModulesDir);
        }
        props.put("python.console.encoding", "UTF-8");
        props.put("python.import.site", "false");
        return props;
    }

    private boolean isInitInterpreter() {
        String pythonHome = System.getenv("PYTHON_HOME");
        if (StringHelper.isNotEmpty((String)pythonHome)) {
            System.setProperty("python.home", pythonHome);
        }
        String pythonHomeProperty = System.getProperty("python.home");
        return StringHelper.isNotEmpty((String)pythonHomeProperty);
    }

    public <T> T loadPythonScript(String scriptName, String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs) throws PythonException {
        if (!this.interpereterReady || StringHelper.isEmpty((String)scriptName)) {
            return null;
        }
        PythonInterpreter currentPythonInterpreter = PythonInterpreter.threadLocalStateInterpreter(null);
        this.initPythonInterpreter(currentPythonInterpreter);
        try {
            currentPythonInterpreter.execfile(scriptName);
        }
        catch (Exception ex) {
            this.log.error("Failed to load python file", (Object)ex.getMessage());
            throw new PythonException(String.format("Failed to load python file '%s'", scriptName), ex);
        }
        return this.loadPythonScript(scriptPythonType, scriptJavaType, constructorArgs, currentPythonInterpreter);
    }

    public <T> T loadPythonScript(InputStream scriptFile, String scriptName, String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs) throws PythonException {
        if (!this.interpereterReady || scriptFile == null) {
            return null;
        }
        PythonInterpreter currentPythonInterpreter = PythonInterpreter.threadLocalStateInterpreter(null);
        this.initPythonInterpreter(currentPythonInterpreter);
        try {
            currentPythonInterpreter.execfile(scriptFile, scriptName);
        }
        catch (Exception ex) {
            this.log.error("Failed to load python file", (Object)ex.getMessage(), (Object)ex);
            throw new PythonException(String.format("Failed to load python file '%s'", scriptFile), ex);
        }
        return this.loadPythonScript(scriptPythonType, scriptJavaType, constructorArgs, currentPythonInterpreter);
    }

    private <T> T loadPythonScript(String scriptPythonType, Class<T> scriptJavaType, PyObject[] constructorArgs, PythonInterpreter interpreter) throws PythonException {
        PyObject scriptPythonTypeClass;
        PyObject scriptPythonTypeObject = interpreter.get(scriptPythonType);
        if (scriptPythonTypeObject == null) {
            return null;
        }
        try {
            scriptPythonTypeClass = scriptPythonTypeObject.__call__(constructorArgs);
        }
        catch (Exception ex) {
            this.log.error("Failed to initialize python class", (Object)ex.getMessage());
            throw new PythonException(String.format("Failed to initialize python class '%s'", scriptPythonType), ex);
        }
        Object scriptJavaClass = scriptPythonTypeClass.__tojava__(scriptJavaType);
        if (!ReflectHelper.assignableFrom(scriptJavaClass.getClass(), scriptJavaType)) {
            return null;
        }
        return (T)scriptJavaClass;
    }

    final class PythonLoggerOutputStream
    extends OutputStream {
        private boolean error;
        private Logger log;
        private StringBuffer buffer;

        private PythonLoggerOutputStream(Logger log, boolean error) {
            this.error = error;
            this.log = log;
            this.buffer = new StringBuffer();
        }

        @Override
        public void write(int b) throws IOException {
            if ((char)b == '\n' || (char)b == '\r') {
                this.flush();
            } else {
                this.buffer.append((char)b);
            }
        }

        @Override
        public void flush() {
            if (this.buffer.length() > 0) {
                if (this.error) {
                    this.log.error(this.buffer.toString());
                } else {
                    this.log.info(this.buffer.toString());
                }
                this.buffer.setLength(0);
            }
        }
    }
}

