/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.util.Date;
import java.util.Properties;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.gluu.model.SmtpConfiguration;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;

@RequestScoped
@Named
public class MailService {
    @Inject
    private Logger log;
    @Inject
    private SmtpConfiguration smtpConfiguration;
    private long connectionTimeout = 5000L;

    public boolean sendMail(String to, String subject, String message) {
        return this.sendMail(this.smtpConfiguration, null, null, to, null, subject, message, null);
    }

    public boolean sendMail(String to, String toDisplayName, String subject, String message, String htmlMessage) {
        return this.sendMail(this.smtpConfiguration, null, null, to, null, subject, message, htmlMessage);
    }

    public boolean sendMail(String from, String fromDisplayName, String to, String toDisplayName, String subject, String message, String htmlMessage) {
        return this.sendMail(this.smtpConfiguration, from, fromDisplayName, to, null, subject, message, htmlMessage);
    }

    public boolean sendMail(SmtpConfiguration mailSmtpConfiguration, String from, String fromDisplayName, String to, String toDisplayName, String subject, String message, String htmlMessage) {
        String mailFromName;
        if (mailSmtpConfiguration == null) {
            this.log.error("Failed to send message from '{}' to '{}' because the SMTP configuration isn't valid!", (Object)from, (Object)to);
            return false;
        }
        this.log.debug("Host name: " + mailSmtpConfiguration.getHost() + ", port: " + mailSmtpConfiguration.getPort() + ", connection time out: " + this.connectionTimeout);
        String mailFrom = from;
        if (StringHelper.isEmpty((String)mailFrom)) {
            mailFrom = mailSmtpConfiguration.getFromEmailAddress();
        }
        if (StringHelper.isEmpty((String)(mailFromName = fromDisplayName))) {
            mailFromName = mailSmtpConfiguration.getFromName();
        }
        Properties props = new Properties();
        props.put("mail.smtp.host", mailSmtpConfiguration.getHost());
        props.put("mail.smtp.port", (Object)mailSmtpConfiguration.getPort());
        props.put("mail.from", mailFrom);
        props.put("mail.smtp.connectiontimeout", (Object)this.connectionTimeout);
        props.put("mail.smtp.timeout", (Object)this.connectionTimeout);
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.ssl.trust", mailSmtpConfiguration.getHost());
        if (mailSmtpConfiguration.isRequiresSsl()) {
            props.put("mail.smtp.socketFactory.port", (Object)mailSmtpConfiguration.getPort());
            props.put("mail.smtp.starttls.enable", (Object)true);
            props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        }
        Session session = null;
        if (mailSmtpConfiguration.isRequiresAuthentication()) {
            props.put("mail.smtp.auth", "true");
            final String userName = mailSmtpConfiguration.getUserName();
            final String password = mailSmtpConfiguration.getPasswordDecrypted();
            session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password);
                }
            });
        } else {
            Session.getInstance((Properties)props, null);
        }
        MimeMessage msg = new MimeMessage(session);
        try {
            msg.setFrom((Address)new InternetAddress(mailFrom, mailFromName));
            if (StringHelper.isEmpty((String)toDisplayName)) {
                msg.setRecipients(Message.RecipientType.TO, to);
            } else {
                msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to, toDisplayName));
            }
            msg.setSubject(subject, "UTF-8");
            msg.setSentDate(new Date());
            if (StringHelper.isEmpty((String)htmlMessage)) {
                msg.setText(message + "\n", "UTF-8", "plain");
            } else {
                MimeBodyPart textPart = new MimeBodyPart();
                textPart.setText(message, "UTF-8", "plain");
                MimeBodyPart htmlPart = new MimeBodyPart();
                htmlPart.setText(htmlMessage, "UTF-8", "html");
                MimeMultipart mp = new MimeMultipart("alternative");
                mp.addBodyPart((BodyPart)textPart);
                mp.addBodyPart((BodyPart)htmlPart);
                msg.setContent((Multipart)mp);
            }
            Transport.send((Message)msg);
        }
        catch (Exception ex) {
            this.log.error("Failed to send message", (Throwable)ex);
            return false;
        }
        return true;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }
}

