/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import java.util.Date;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.gluu.service.cache.CacheInterface;
import org.gluu.service.cache.CacheProvider;
import org.gluu.service.cache.CacheProviderType;
import org.slf4j.Logger;

public abstract class BaseCacheService
implements CacheInterface {
    private static int DEFAULT_EXPIRATION = 60;
    @Inject
    private Logger log;

    @Override
    public Object get(String key) {
        CacheProvider cacheProvider = this.getCacheProvider();
        if (cacheProvider == null) {
            this.log.error("Cache provider is invalid!");
            return null;
        }
        this.log.trace("Request data, key '{}'", (Object)key);
        Object value = cacheProvider.get(key);
        this.log.trace("Loaded data, key '{}': '{}'", (Object)key, value);
        return value;
    }

    public <T> T getWithPut(String key, Supplier<T> loadFunction, int expirationInSeconds) {
        if (loadFunction == null) {
            return (T)this.get(key);
        }
        CacheProvider cacheProvider = this.getCacheProvider();
        if (CacheProviderType.NATIVE_PERSISTENCE == cacheProvider.getProviderType()) {
            this.log.trace("Loading data from DB without cache, key '{}'", (Object)key);
            return loadFunction.get();
        }
        Object value = this.get(key);
        if (value != null) {
            this.log.trace("Loaded from cache, key: '{}'", (Object)key);
            return (T)value;
        }
        this.log.trace("Key not in cache. Searching value via load function, key: '{}'", (Object)key);
        T loaded = loadFunction.get();
        if (loaded == null) {
            this.log.trace("Key not in cache. There is no value, key: '{}'", (Object)key);
            return null;
        }
        try {
            this.put(expirationInSeconds, key, loaded);
        }
        catch (Exception e) {
            this.log.error("Failed to put object into cache, key: '{}'", (Object)key, (Object)e);
        }
        return loaded;
    }

    @Override
    public void put(int expirationInSeconds, String key, Object object) {
        CacheProvider cacheProvider = this.getCacheProvider();
        if (cacheProvider == null) {
            this.log.error("Cache provider is invalid!");
            return;
        }
        this.log.trace("Put data, key '{}': '{}'", (Object)key, object);
        cacheProvider.put(expirationInSeconds, key, object);
    }

    @Override
    public void remove(String key) {
        CacheProvider cacheProvider = this.getCacheProvider();
        if (cacheProvider == null) {
            this.log.error("Cache provider is invalid!");
            return;
        }
        this.log.trace("Remove data, key '{}'", (Object)key);
        cacheProvider.remove(key);
    }

    @Override
    public void clear() {
        CacheProvider cacheProvider = this.getCacheProvider();
        if (cacheProvider == null) {
            this.log.error("Cache provider is invalid!");
            return;
        }
        this.log.trace("Clear cache");
        cacheProvider.clear();
    }

    @Override
    public void cleanup(Date now) {
        CacheProvider cacheProvider = this.getCacheProvider();
        if (cacheProvider == null) {
            this.log.error("Cache provider is invalid!");
            return;
        }
        this.log.trace("Clean up cache");
        cacheProvider.cleanup(now);
    }

    public void put(String key, Object object) {
        this.put(DEFAULT_EXPIRATION, key, object);
    }

    @Deprecated
    public Object get(String region, String key) {
        return this.get(key);
    }

    @Deprecated
    public void put(String expirationInSeconds, String key, Object object) {
        int expiration = DEFAULT_EXPIRATION;
        try {
            expiration = Integer.parseInt(expirationInSeconds);
        }
        catch (NumberFormatException ex) {
            this.log.trace("Using default expiration instead of expirationInSeconds: {}", (Object)expirationInSeconds);
        }
        this.put(expiration, key, object);
    }

    @Deprecated
    public void remove(String region, String key) {
        this.remove(key);
    }

    protected abstract CacheProvider getCacheProvider();
}

