/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.service;

import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gluu.model.GluuAttribute;
import org.gluu.model.SchemaEntry;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.search.filter.Filter;
import org.gluu.service.BaseCacheService;
import org.gluu.service.CacheService;
import org.gluu.service.LocalCacheService;
import org.gluu.service.SchemaService;
import org.slf4j.Logger;

public abstract class AttributeService
implements Serializable {
    private static final long serialVersionUID = -1311784648561611479L;
    @Inject
    protected Logger log;
    @Inject
    protected PersistenceEntryManager ldapEntryManager;
    @Inject
    protected SchemaService schemaService;
    @Inject
    protected CacheService cacheService;
    @Inject
    protected LocalCacheService localCacheService;

    public List<GluuAttribute> getAttributesByAttribute(String attributeName, String attributeValue, String baseDn) {
        String[] targetArray = new String[]{attributeValue};
        Filter filter = Filter.createSubstringFilter((String)attributeName, null, (String[])targetArray, null);
        List result = this.ldapEntryManager.findEntries(baseDn, GluuAttribute.class, filter);
        return result;
    }

    public String getDefaultSaml2Uri(String name) {
        SchemaEntry schemaEntry = this.schemaService.getSchema();
        if (schemaEntry == null) {
            ArrayList<String> attributeNames = new ArrayList<String>();
            attributeNames.add(name);
            List<AttributeTypeDefinition> attributeTypes = this.schemaService.getAttributeTypeDefinitions(schemaEntry, attributeNames);
            AttributeTypeDefinition attributeTypeDefinition = this.schemaService.getAttributeTypeDefinition(attributeTypes, name);
            if (attributeTypeDefinition != null) {
                return String.format("urn:oid:%s", attributeTypeDefinition.getOID());
            }
        }
        return "";
    }

    public GluuAttribute getAttributeByName(String name) {
        return this.getAttributeByName(name, this.getAllAttributes());
    }

    public GluuAttribute getAttributeByName(String name, List<GluuAttribute> attributes) {
        for (GluuAttribute attribute : attributes) {
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }

    public List<GluuAttribute> getAllAttributes() {
        return this.getAllAttributes(this.getDnForAttribute(null));
    }

    public List<GluuAttribute> getAllAttributes(String baseDn) {
        BaseCacheService usedCacheService = this.getCacheService();
        List<GluuAttribute> attributeList = (List<GluuAttribute>)usedCacheService.get("AttributeCache", "attributeList");
        if (attributeList == null) {
            attributeList = this.getAllAtributesImpl(baseDn);
            usedCacheService.put("AttributeCache", "attributeList", attributeList);
        }
        return attributeList;
    }

    protected List<GluuAttribute> getAllAtributesImpl(String baseDn) {
        List attributeList = this.ldapEntryManager.findEntries(baseDn, GluuAttribute.class, null);
        return attributeList;
    }

    protected abstract BaseCacheService getCacheService();

    public abstract String getDnForAttribute(String var1);
}

