/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.model.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.AttributesList;
import org.gluu.persist.annotation.CustomObjectClass;
import org.gluu.persist.annotation.DN;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.annotation.ObjectClass;
import org.gluu.persist.model.base.CustomObjectAttribute;
import org.gluu.util.StringHelper;

@DataEntry
@ObjectClass
public class SimpleUser
implements Serializable {
    private static final long serialVersionUID = -1634191420188575733L;
    @DN
    private String dn;
    @AttributeName(name="uid", consistency=true)
    private String userId;
    @AttributeName
    private Date updatedAt;
    @AttributeName(name="oxCreationTimestamp")
    private Date createdAt;
    @AttributeName(name="oxAuthPersistentJWT")
    private String[] oxAuthPersistentJwt;
    @AttributesList(name="name", value="values", multiValued="multiValued", sortByName=true)
    protected List<CustomObjectAttribute> customAttributes = new ArrayList<CustomObjectAttribute>();
    @CustomObjectClass
    private String[] customObjectClasses;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String[] getOxAuthPersistentJwt() {
        return this.oxAuthPersistentJwt;
    }

    public void setOxAuthPersistentJwt(String[] oxAuthPersistentJwt) {
        this.oxAuthPersistentJwt = oxAuthPersistentJwt;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public List<CustomObjectAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomObjectAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getAttribute(String attributeName) {
        Object objectAttribute = this.getAttributeObject(attributeName);
        return StringHelper.toString((Object)objectAttribute);
    }

    public Object getAttributeObject(String attributeName) {
        Object attribute = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomObjectAttribute customAttribute : this.customAttributes) {
                if (!customAttribute.getName().equals(attributeName)) continue;
                attribute = customAttribute.getValue();
                break;
            }
        }
        return attribute;
    }

    public List<String> getAttributeValues(String attributeName) {
        List<Object> objectValues = this.getAttributeObjectValues(attributeName);
        if (objectValues == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>(objectValues.size());
        for (Object objectValue : objectValues) {
            values.add(StringHelper.toString((Object)objectValue));
        }
        return values;
    }

    public List<Object> getAttributeObjectValues(String attributeName) {
        List<Object> values = null;
        if (attributeName != null && !attributeName.isEmpty()) {
            for (CustomObjectAttribute customAttribute : this.customAttributes) {
                if (!StringHelper.equalsIgnoreCase((String)customAttribute.getName(), (String)attributeName)) continue;
                values = customAttribute.getValues();
                break;
            }
        }
        return values;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] customObjectClasses) {
        this.customObjectClasses = customObjectClasses;
    }
}

