/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.model.base;

import java.util.Date;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.annotation.DataEntry;
import org.gluu.persist.model.base.BaseEntry;
import org.gluu.persist.model.base.Deletable;

@DataEntry
public class DeletableEntity
extends BaseEntry
implements Deletable {
    @AttributeName(name="exp")
    private Date expirationDate;
    @AttributeName(name="del")
    private Boolean deletable;

    @Override
    public Boolean isDeletable() {
        return this.deletable;
    }

    public void setDeletable(Boolean deletable) {
        this.deletable = deletable;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public boolean canDelete() {
        return this.canDelete(new Date());
    }

    public boolean canDelete(Date now) {
        Date exp = this.expirationDate != null ? this.expirationDate : null;
        return this.deletable != null && this.deletable != false && (exp == null || exp.before(now));
    }

    @Override
    public String toString() {
        Date exp = this.expirationDate != null ? this.expirationDate : null;
        return "DeletableEntity{expirationDate=" + exp + ", deletable=" + this.deletable + "} " + super.toString();
    }
}

