/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.model.base;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CustomObjectAttribute
implements Serializable,
Comparable<CustomObjectAttribute> {
    private static final long serialVersionUID = -1238450094325306154L;
    private String name;
    private boolean multiValued;
    private List<Object> values;

    public CustomObjectAttribute() {
    }

    public CustomObjectAttribute(String name) {
        this.name = name;
    }

    public CustomObjectAttribute(String name, Object value) {
        this.name = name;
        this.setValue(value);
        this.multiValued = false;
    }

    public CustomObjectAttribute(String name, List<Object> values) {
        this.name = name;
        this.setValues(values);
    }

    public Object getValue() {
        if (this.values == null) {
            return null;
        }
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public void setValue(Object value) {
        this.values = new ArrayList<Object>();
        this.values.add(value);
        this.multiValued = false;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
        this.multiValued = values != null && values.size() > 1;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public String getDisplayValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.size() == 1) {
            return this.values.get(0).toString();
        }
        StringBuilder sb = new StringBuilder(this.values.get(0).toString());
        for (int i = 1; i < this.values.size(); ++i) {
            sb.append(", ").append(this.values.get(i).toString());
        }
        return sb.toString();
    }

    private String toStringValue() {
        if (this.values == null) {
            return "";
        }
        if (this.values.size() == 1) {
            if (this.multiValued) {
                return "[" + this.values.get(0).toString() + "]";
            }
            return this.values.get(0).toString();
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.values.get(i).toString());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomObjectAttribute that = (CustomObjectAttribute)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return String.format("Attribute [name=%s, multiValued=%s, value=%s]", this.name, this.multiValued, this.toStringValue());
    }

    @Override
    public int compareTo(CustomObjectAttribute o) {
        return this.name.compareTo(o.name);
    }
}

