/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.operation.impl;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.document.Document;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.Delete;
import com.couchbase.client.java.query.N1qlParams;
import com.couchbase.client.java.query.N1qlQuery;
import com.couchbase.client.java.query.N1qlQueryResult;
import com.couchbase.client.java.query.N1qlQueryRow;
import com.couchbase.client.java.query.Select;
import com.couchbase.client.java.query.Statement;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.query.dsl.path.GroupByPath;
import com.couchbase.client.java.query.dsl.path.LimitPath;
import com.couchbase.client.java.query.dsl.path.MutateLimitPath;
import com.couchbase.client.java.query.dsl.path.OffsetPath;
import com.couchbase.client.java.query.dsl.path.ReturningPath;
import com.couchbase.client.java.subdoc.DocumentFragment;
import com.couchbase.client.java.subdoc.MutateInBuilder;
import com.couchbase.client.java.subdoc.MutationSpec;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gluu.persist.couchbase.impl.CouchbaseBatchOperationWraper;
import org.gluu.persist.couchbase.model.BucketMapping;
import org.gluu.persist.couchbase.model.SearchReturnDataType;
import org.gluu.persist.couchbase.operation.CouchbaseOperationService;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.couchbase.operation.watch.OperationDurationUtil;
import org.gluu.persist.exception.extension.PersistenceExtension;
import org.gluu.persist.exception.operation.DeleteException;
import org.gluu.persist.exception.operation.DuplicateEntryException;
import org.gluu.persist.exception.operation.EntryNotFoundException;
import org.gluu.persist.exception.operation.PersistenceException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.operation.auth.PasswordEncryptionHelper;
import org.gluu.persist.operation.auth.PasswordEncryptionMethod;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseOperationServiceImpl
implements CouchbaseOperationService {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    private Properties props;
    private CouchbaseConnectionProvider connectionProvider;
    private ScanConsistency scanConsistency = ScanConsistency.NOT_BOUNDED;
    private boolean ignoreAttributeScanConsistency = false;
    private boolean attemptWithoutAttributeScanConsistency = true;
    private boolean enableScopeSupport = false;
    private boolean disableAttributeMapping = false;
    private PersistenceExtension persistenceExtension;

    private CouchbaseOperationServiceImpl() {
    }

    public CouchbaseOperationServiceImpl(Properties props, CouchbaseConnectionProvider connectionProvider) {
        this.props = props;
        this.connectionProvider = connectionProvider;
        this.init();
    }

    private void init() {
        if (this.props.containsKey("connection.scan-consistency")) {
            String scanConsistencyString = StringHelper.toUpperCase((String)this.props.get("connection.scan-consistency").toString());
            this.scanConsistency = ScanConsistency.valueOf((String)scanConsistencyString);
        }
        if (this.props.containsKey("connection.ignore-attribute-scan-consistency")) {
            this.ignoreAttributeScanConsistency = StringHelper.toBoolean((String)this.props.get("connection.ignore-attribute-scan-consistency").toString(), (boolean)this.ignoreAttributeScanConsistency);
        }
        if (this.props.containsKey("connection.attempt-without-attribute-scan-consistency")) {
            this.attemptWithoutAttributeScanConsistency = StringHelper.toBoolean((String)this.props.get("attempt-without-attribute-scan-consistency").toString(), (boolean)this.attemptWithoutAttributeScanConsistency);
        }
        if (this.props.containsKey("connection.enable-scope-support")) {
            this.enableScopeSupport = StringHelper.toBoolean((String)this.props.get("connection.enable-scope-support").toString(), (boolean)this.enableScopeSupport);
        }
        if (this.props.containsKey("connection.disable-attribute-mapping")) {
            this.disableAttributeMapping = StringHelper.toBoolean((String)this.props.get("connection.disable-attribute-mapping").toString(), (boolean)this.disableAttributeMapping);
        }
        LOG.info("Option scanConsistency: " + this.scanConsistency);
        LOG.info("Option ignoreAttributeScanConsistency: " + this.ignoreAttributeScanConsistency);
        LOG.info("Option enableScopeSupport: " + this.enableScopeSupport);
        LOG.info("Option disableAttributeMapping: " + this.disableAttributeMapping);
    }

    @Override
    public CouchbaseConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    @Override
    public boolean authenticate(String key, String password) throws SearchException {
        return this.authenticateImpl(key, password);
    }

    private boolean authenticateImpl(String key, String password) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        boolean result = false;
        if (password != null) {
            JsonObject entry = this.lookup(key, null, "userPassword");
            Object userPasswordObj = entry.get("userPassword");
            String userPassword = null;
            if (userPasswordObj instanceof JsonArray) {
                userPassword = ((JsonArray)userPasswordObj).getString(0);
            } else if (userPasswordObj instanceof String) {
                userPassword = (String)userPasswordObj;
            }
            if (userPassword != null) {
                result = this.persistenceExtension == null ? PasswordEncryptionHelper.compareCredentials((String)password, (String)userPassword) : this.persistenceExtension.compareHashedPasswords(password, userPassword);
            }
        }
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        OperationDurationUtil.instance().logDebug("Couchbase operation: bind, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    @Override
    public boolean addEntry(String key, JsonObject jsonObject) throws DuplicateEntryException, PersistenceException {
        return this.addEntry(key, jsonObject, 0);
    }

    @Override
    public boolean addEntry(String key, JsonObject jsonObject, Integer expiration) throws DuplicateEntryException, PersistenceException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.addEntryImpl(bucketMapping, key, jsonObject, expiration);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: add, duration: {}, bucket: {}, key: {}, json: {}", new Object[]{duration, bucketMapping.getBucketName(), key, jsonObject});
        return result;
    }

    private boolean addEntryImpl(BucketMapping bucketMapping, String key, JsonObject jsonObject, Integer expiration) throws PersistenceException {
        try {
            JsonDocument jsonDocument = expiration == null ? JsonDocument.create((String)key, (JsonObject)jsonObject) : JsonDocument.create((String)key, (int)expiration, (JsonObject)jsonObject);
            JsonDocument result = (JsonDocument)bucketMapping.getBucket().upsert((Document)jsonDocument);
            if (result != null) {
                return true;
            }
        }
        catch (CouchbaseException ex) {
            throw new PersistenceException("Failed to add entry", (Throwable)ex);
        }
        return false;
    }

    @Deprecated
    protected boolean updateEntry(String key, JsonObject attrs) throws UnsupportedOperationException, SearchException {
        ArrayList<MutationSpec> mods = new ArrayList<MutationSpec>();
        for (Map.Entry attrEntry : attrs.toMap().entrySet()) {
            String attributeName = (String)attrEntry.getKey();
            Object attributeValue = attrEntry.getValue();
            if (attributeName.equalsIgnoreCase("objectClass") || attributeName.equalsIgnoreCase("dn") || attributeName.equalsIgnoreCase("userPassword") || attributeValue == null) continue;
            mods.add(new MutationSpec(Mutation.REPLACE, attributeName, attributeValue));
        }
        return this.updateEntry(key, mods, null);
    }

    @Override
    public boolean updateEntry(String key, List<MutationSpec> mods, Integer expiration) throws UnsupportedOperationException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.updateEntryImpl(bucketMapping, key, mods, expiration);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: modify, duration: {}, bucket: {}, key: {}, mods: {}", new Object[]{duration, bucketMapping.getBucketName(), key, mods});
        return result;
    }

    private boolean updateEntryImpl(BucketMapping bucketMapping, String key, List<MutationSpec> mods, Integer expiration) throws SearchException {
        try {
            MutateInBuilder builder = bucketMapping.getBucket().mutateIn(key);
            if (expiration != null) {
                builder = builder.withExpiry(expiration.intValue());
            }
            return this.modifyEntry(builder, mods);
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to update entry", (Throwable)ex);
        }
    }

    protected boolean modifyEntry(MutateInBuilder builder, List<MutationSpec> mods) throws UnsupportedOperationException, SearchException {
        try {
            for (MutationSpec mod : mods) {
                Mutation type = mod.type();
                if (Mutation.DICT_ADD == type) {
                    builder.insert(mod.path(), mod.fragment());
                    continue;
                }
                if (Mutation.REPLACE == type) {
                    builder.replace(mod.path(), mod.fragment());
                    continue;
                }
                if (Mutation.DELETE == type) {
                    builder.remove(mod.path());
                    continue;
                }
                throw new UnsupportedOperationException("Operation type '" + type + "' is not implemented");
            }
            DocumentFragment result = builder.execute();
            if (result.size() > 0) {
                return result.status(0).isSuccess();
            }
            return false;
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to update entry", (Throwable)ex);
        }
    }

    @Override
    public boolean delete(String key) throws EntryNotFoundException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.deleteImpl(bucketMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    private boolean deleteImpl(BucketMapping bucketMapping, String key) throws EntryNotFoundException {
        try {
            JsonDocument result = bucketMapping.getBucket().remove(key);
            return result != null && result.id() != null;
        }
        catch (CouchbaseException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public int delete(String key, ScanConsistency scanConsistency, Expression expression, int count) throws DeleteException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        ScanConsistency useScanConsistency = this.getScanConsistency(scanConsistency, false);
        int result = this.deleteImpl(bucketMapping, key, useScanConsistency, expression, count);
        String attemptInfo = this.getScanAttemptLogInfo(scanConsistency, useScanConsistency, false);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete_search, duration: {}, bucket: {}, key: {}, expression: {}, count: {}, consistency: {}{}", new Object[]{duration, bucketMapping.getBucketName(), key, expression, count, useScanConsistency, attemptInfo});
        return result;
    }

    private int deleteImpl(BucketMapping bucketMapping, String key, ScanConsistency scanConsistency, Expression expression, int count) throws DeleteException {
        Bucket bucket = bucketMapping.getBucket();
        Expression finalExpression = expression;
        if (this.enableScopeSupport) {
            Expression scopeExpression = Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"}));
            finalExpression = scopeExpression.and(expression);
        }
        MutateLimitPath deleteQuery = Delete.deleteFrom((Expression)Expression.i((String[])new String[]{bucketMapping.getBucketName()})).where(finalExpression);
        ReturningPath query = deleteQuery.limit(count);
        LOG.debug("Execution query: '" + query + "'");
        N1qlQueryResult result = bucket.query((N1qlQuery)N1qlQuery.simple((Statement)query, (N1qlParams)N1qlParams.build().consistency(scanConsistency)));
        if (!result.finalSuccess()) {
            throw new DeleteException(String.format("Failed to delete entries. Query: '%s'. Error: '%s', Error count: '%d'", query, result.errors(), result.info().errorCount()), ((JsonObject)result.errors().get(0)).getInt("code").intValue());
        }
        return result.info().mutationCount();
    }

    @Override
    public boolean deleteRecursively(String key) throws EntryNotFoundException, SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean result = this.deleteRecursivelyImpl(bucketMapping, key);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: delete_tree, duration: {}, bucket: {}, key: {}", new Object[]{duration, bucketMapping.getBucketName(), key});
        return result;
    }

    private boolean deleteRecursivelyImpl(BucketMapping bucketMapping, String key) throws SearchException, EntryNotFoundException {
        try {
            if (this.enableScopeSupport) {
                MutateLimitPath deleteQuery = Delete.deleteFrom((Expression)Expression.i((String[])new String[]{bucketMapping.getBucketName()})).where(Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})));
                N1qlQueryResult result = bucketMapping.getBucket().query((Statement)deleteQuery);
                if (!result.finalSuccess()) {
                    throw new SearchException(String.format("Failed to delete entries. Query: '%s'. Error: '%s', Error count: '%d'", deleteQuery, result.errors(), result.info().errorCount()), ((JsonObject)result.errors().get(0)).getInt("code").intValue());
                }
            } else {
                LOG.warn("Removing only base key without sub-tree: " + key);
                this.delete(key);
            }
            return true;
        }
        catch (CouchbaseException ex) {
            throw new EntryNotFoundException("Failed to delete entry", (Throwable)ex);
        }
    }

    @Override
    public JsonObject lookup(String key, ScanConsistency scanConsistency, String ... attributes) throws SearchException {
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean secondTry = false;
        ScanConsistency useScanConsistency = this.getScanConsistency(scanConsistency, this.attemptWithoutAttributeScanConsistency);
        JsonObject result = null;
        SearchException lastException = null;
        try {
            result = this.lookupImpl(bucketMapping, key, useScanConsistency, attributes);
        }
        catch (SearchException ex) {
            lastException = ex;
        }
        if (result == null || result.isEmpty()) {
            ScanConsistency useScanConsistency2 = this.getScanConsistency(scanConsistency, false);
            if (!useScanConsistency2.equals((Object)useScanConsistency)) {
                useScanConsistency = useScanConsistency2;
                secondTry = true;
                result = this.lookupImpl(bucketMapping, key, useScanConsistency, attributes);
            } else if (lastException != null) {
                throw lastException;
            }
        }
        String attemptInfo = this.getScanAttemptLogInfo(scanConsistency, useScanConsistency, secondTry);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: lookup, duration: {}, bucket: {}, key: {}, attributes: {}, consistency: {}{}", new Object[]{duration, bucketMapping.getBucketName(), key, attributes, useScanConsistency, attemptInfo});
        return result;
    }

    private JsonObject lookupImpl(BucketMapping bucketMapping, String key, ScanConsistency scanConsistency, String ... attributes) throws SearchException {
        try {
            Bucket bucket = bucketMapping.getBucket();
            if (ArrayHelper.isEmpty((Object[])attributes)) {
                JsonDocument doc = bucket.get(key);
                if (doc != null) {
                    return (JsonObject)doc.content();
                }
            } else {
                JsonDocument doc = bucket.get(key);
                if (doc != null) {
                    HashSet<String> docAtributesKeep = new HashSet<String>(Arrays.asList(attributes));
                    Iterator it = ((JsonObject)doc.content()).getNames().iterator();
                    while (it.hasNext()) {
                        String docAtribute = (String)it.next();
                        if (docAtributesKeep.contains(docAtribute)) continue;
                        it.remove();
                    }
                    return (JsonObject)doc.content();
                }
            }
        }
        catch (CouchbaseException ex) {
            throw new SearchException("Failed to lookup entry", (Throwable)ex);
        }
        throw new SearchException("Failed to lookup entry");
    }

    @Override
    public <O> PagedResult<JsonObject> search(String key, ScanConsistency scanConsistency, Expression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        ScanConsistency useScanConsistency2;
        Instant startTime = OperationDurationUtil.instance().now();
        BucketMapping bucketMapping = this.connectionProvider.getBucketMappingByKey(key);
        boolean secondTry = false;
        ScanConsistency useScanConsistency = this.getScanConsistency(scanConsistency, this.attemptWithoutAttributeScanConsistency);
        PagedResult<JsonObject> result = null;
        int attemps = 20;
        while (true) {
            --attemps;
            try {
                result = this.searchImpl(bucketMapping, key, useScanConsistency, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
            }
            catch (SearchException ex) {
                if (ex.getErrorCode() != 5000) {
                    throw ex;
                }
                LOG.warn("Waiting for Indexer Warmup...");
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (attemps > 0) continue;
            }
            break;
        }
        if (!(result != null && result.getEntriesCount() != 0 || (useScanConsistency2 = this.getScanConsistency(scanConsistency, false)).equals((Object)useScanConsistency))) {
            useScanConsistency = useScanConsistency2;
            result = this.searchImpl(bucketMapping, key, useScanConsistency, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
            secondTry = true;
        }
        String attemptInfo = this.getScanAttemptLogInfo(scanConsistency, useScanConsistency, secondTry);
        Duration duration = OperationDurationUtil.instance().duration(startTime);
        OperationDurationUtil.instance().logDebug("Couchbase operation: search, duration: {}, bucket: {}, key: {}, expression: {}, scope: {}, attributes: {}, orderBy: {}, batchOperationWraper: {}, returnDataType: {}, start: {}, count: {}, pageSize: {}, consistency: {}{}", new Object[]{duration, bucketMapping.getBucketName(), key, expression, scope, attributes, orderBy, batchOperationWraper, returnDataType, start, count, pageSize, useScanConsistency, attemptInfo});
        return result;
    }

    private <O> PagedResult<JsonObject> searchImpl(BucketMapping bucketMapping, String key, ScanConsistency scanConsistency, Expression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        GroupByPath selectQuery;
        Bucket bucket = bucketMapping.getBucket();
        BatchOperation<O> ldapBatchOperation = null;
        if (batchOperationWraper != null) {
            ldapBatchOperation = batchOperationWraper.getBatchOperation();
        }
        if (LOG.isTraceEnabled() && StringHelper.equalsIgnoreCase((String)key, (String)"_")) {
            LOG.trace("Search in whole DB tree", (Throwable)new Exception());
        }
        Expression finalExpression = expression;
        if (this.enableScopeSupport) {
            Expression scopeExpression = scope == null ? null : (SearchScope.BASE == scope ? Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})).and(Expression.path((Object[])new Object[]{"META().id"}).notLike(Expression.s((String[])new String[]{key + "\\\\_%\\\\_"}))) : Expression.path((Object[])new Object[]{"META().id"}).like(Expression.s((String[])new String[]{key + "%"})));
            if (scopeExpression != null) {
                finalExpression = scopeExpression.and(expression);
            }
        } else if (scope != null) {
            LOG.debug("Ignoring scope '" + scope + " for expression: " + expression);
        }
        String[] select = attributes;
        if (select == null) {
            select = new String[]{"gluu_doc.*", "dn"};
        } else if (select.length == 1 && StringHelper.isEmpty((String)select[0])) {
            select = new String[]{"dn"};
        } else {
            boolean hasDn = Arrays.asList(select).contains("dn");
            if (!hasDn) {
                select = (String[])ArrayHelper.arrayMerge((Object[][])new String[][]{select, {"dn"}});
            }
        }
        GroupByPath baseQuery = selectQuery = Select.select((String[])select).from(Expression.i((String[])new String[]{bucketMapping.getBucketName()})).as("gluu_doc").where(finalExpression);
        if (orderBy != null) {
            baseQuery = selectQuery.orderBy(orderBy);
        }
        ArrayList searchResultList = new ArrayList();
        if (SearchReturnDataType.SEARCH == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            N1qlQueryResult lastResult = null;
            if (pageSize > 0) {
                Statement query = null;
                try {
                    List lastSearchResultList;
                    int resultCount = 0;
                    do {
                        boolean collectSearchResult = true;
                        int currentLimit = pageSize;
                        if (count > 0) {
                            currentLimit = Math.min(pageSize, count - resultCount);
                        }
                        query = baseQuery.limit(currentLimit).offset(start + resultCount);
                        LOG.debug("Execution query: '" + query + "'");
                        lastResult = bucket.query((N1qlQuery)N1qlQuery.simple((Statement)query, (N1qlParams)N1qlParams.build().consistency(scanConsistency)));
                        if (!lastResult.finalSuccess()) {
                            throw new SearchException(String.format("Failed to search entries. Query: '%s'. Error: '%s', Error count: '%d'", query, lastResult.errors(), lastResult.info().errorCount()), ((JsonObject)lastResult.errors().get(0)).getInt("code").intValue());
                        }
                        lastSearchResultList = lastResult.allRows();
                        if (ldapBatchOperation != null) {
                            collectSearchResult = ldapBatchOperation.collectSearchResult(lastSearchResultList.size());
                        }
                        if (collectSearchResult) {
                            searchResultList.addAll(lastSearchResultList);
                        }
                        if (ldapBatchOperation == null) continue;
                        List<O> entries = batchOperationWraper.createEntities(lastSearchResultList);
                        ldapBatchOperation.performAction(entries);
                    } while ((count <= 0 || (resultCount += lastSearchResultList.size()) < count) && lastSearchResultList.size() > 0);
                }
                catch (CouchbaseException ex) {
                    throw new SearchException("Failed to search entries. Query: '" + query + "'", (Throwable)ex);
                }
            }
            try {
                GroupByPath query = baseQuery;
                if (count > 0) {
                    query = ((LimitPath)query).limit(count);
                }
                if (start > 0) {
                    query = ((OffsetPath)query).offset(start);
                }
                LOG.debug("Execution query: '" + query + "'");
                lastResult = bucket.query((N1qlQuery)N1qlQuery.simple((Statement)query, (N1qlParams)N1qlParams.build().consistency(scanConsistency)));
                if (!lastResult.finalSuccess()) {
                    throw new SearchException(String.format("Failed to search entries. Query: '%s'. Error: '%s', Error count: '%d'", baseQuery, lastResult.errors(), lastResult.info().errorCount()), ((JsonObject)lastResult.errors().get(0)).getInt("code").intValue());
                }
                searchResultList.addAll(lastResult.allRows());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to search entries. Query: '" + baseQuery.toString() + "'", (Throwable)ex);
            }
        }
        ArrayList<JsonObject> resultRows = new ArrayList<JsonObject>(searchResultList.size());
        for (N1qlQueryRow row : searchResultList) {
            resultRows.add(row.value());
        }
        PagedResult result = new PagedResult();
        result.setEntries(resultRows);
        result.setEntriesCount(resultRows.size());
        result.setStart(start);
        if (SearchReturnDataType.COUNT == returnDataType || SearchReturnDataType.SEARCH_COUNT == returnDataType) {
            GroupByPath selectCountQuery = Select.select((String[])new String[]{"COUNT(*) as TOTAL"}).from(Expression.i((String[])new String[]{bucketMapping.getBucketName()})).where(finalExpression);
            try {
                LOG.debug("Calculating count. Execution query: '" + selectCountQuery + "'");
                N1qlQueryResult countResult = bucket.query((N1qlQuery)N1qlQuery.simple((Statement)selectCountQuery, (N1qlParams)N1qlParams.build().consistency(scanConsistency)));
                if (!countResult.finalSuccess() || countResult.info().resultCount() != 1) {
                    throw new SearchException(String.format("Failed to calculate count entries. Query: '%s'. Error: '%s', Error count: '%d'", selectCountQuery, countResult.errors(), countResult.info().errorCount()), ((JsonObject)countResult.errors().get(0)).getInt("code").intValue());
                }
                result.setTotalEntriesCount(((N1qlQueryRow)countResult.allRows().get(0)).value().getInt("TOTAL").intValue());
            }
            catch (CouchbaseException ex) {
                throw new SearchException("Failed to calculate count entries. Query: '" + selectCountQuery.toString() + "'", (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public String[] createStoragePassword(String[] passwords) {
        if (ArrayHelper.isEmpty((Object[])passwords)) {
            return passwords;
        }
        String[] results = new String[passwords.length];
        for (int i = 0; i < passwords.length; ++i) {
            results[i] = this.persistenceExtension == null ? PasswordEncryptionHelper.createStoragePassword((String)passwords[i], (PasswordEncryptionMethod)this.connectionProvider.getPasswordEncryptionMethod()) : this.persistenceExtension.createHashedPassword(passwords[i]);
        }
        return results;
    }

    @Override
    public boolean isBinaryAttribute(String attribute) {
        return this.connectionProvider.isBinaryAttribute(attribute);
    }

    @Override
    public boolean isCertificateAttribute(String attribute) {
        return this.connectionProvider.isCertificateAttribute(attribute);
    }

    private ScanConsistency getScanConsistency(ScanConsistency operationScanConsistency, boolean ignore) {
        if (ignore) {
            return this.scanConsistency;
        }
        if (this.ignoreAttributeScanConsistency) {
            return this.scanConsistency;
        }
        if (operationScanConsistency != null) {
            return operationScanConsistency;
        }
        return this.scanConsistency;
    }

    public ScanConsistency getScanConsistency() {
        return this.scanConsistency;
    }

    public boolean isDisableAttributeMapping() {
        return this.disableAttributeMapping;
    }

    @Override
    public boolean destroy() {
        boolean result = true;
        if (this.connectionProvider != null) {
            try {
                this.connectionProvider.destroy();
            }
            catch (Exception ex) {
                LOG.error("Failed to destory provider correctly");
                result = false;
            }
        }
        return result;
    }

    public boolean isConnected() {
        return this.connectionProvider.isConnected();
    }

    protected String getScanAttemptLogInfo(ScanConsistency scanConsistency, ScanConsistency usedScanConsistency, boolean secondTry) {
        String attemptInfo = "";
        if (secondTry) {
            attemptInfo = ", attempt: second";
        } else {
            ScanConsistency useScanConsistency2 = this.getScanConsistency(scanConsistency, false);
            if (!useScanConsistency2.equals((Object)usedScanConsistency)) {
                attemptInfo = ", attempt: first";
            }
        }
        return attemptInfo;
    }

    public void setPersistenceExtension(PersistenceExtension persistenceExtension) {
        this.persistenceExtension = persistenceExtension;
    }
}

