/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.core.message.kv.subdoc.multi.Mutation;
import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.query.consistency.ScanConsistency;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.Sort;
import com.couchbase.client.java.subdoc.MutationSpec;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.inject.Inject;
import org.gluu.persist.PersistenceEntryManager;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.couchbase.impl.CouchbaseBatchOperationWraper;
import org.gluu.persist.couchbase.impl.CouchbaseFilterConverter;
import org.gluu.persist.couchbase.model.ConvertedExpression;
import org.gluu.persist.couchbase.model.SearchReturnDataType;
import org.gluu.persist.couchbase.operation.CouchbaseOperationService;
import org.gluu.persist.couchbase.operation.impl.CouchbaseConnectionProvider;
import org.gluu.persist.event.DeleteNotifier;
import org.gluu.persist.exception.AuthenticationException;
import org.gluu.persist.exception.EntryDeleteException;
import org.gluu.persist.exception.EntryPersistenceException;
import org.gluu.persist.exception.MappingException;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.impl.BaseEntryManager;
import org.gluu.persist.key.impl.GenericKeyConverter;
import org.gluu.persist.key.impl.model.ParsedKey;
import org.gluu.persist.model.AttributeData;
import org.gluu.persist.model.AttributeDataModification;
import org.gluu.persist.model.BatchOperation;
import org.gluu.persist.model.DefaultBatchOperation;
import org.gluu.persist.model.PagedResult;
import org.gluu.persist.model.SearchScope;
import org.gluu.persist.model.SortOrder;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.search.filter.Filter;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseEntryManager
extends BaseEntryManager
implements Serializable {
    private static final long serialVersionUID = 2127241817126412574L;
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConnectionProvider.class);
    @Inject
    private Logger log;
    private final CouchbaseFilterConverter FILTER_CONVERTER;
    private static final GenericKeyConverter KEY_CONVERTER = new GenericKeyConverter();
    private List<DeleteNotifier> subscribers;

    protected CouchbaseEntryManager(CouchbaseOperationService operationService) {
        this.operationService = operationService;
        this.FILTER_CONVERTER = new CouchbaseFilterConverter(this);
        this.subscribers = new LinkedList<DeleteNotifier>();
    }

    public boolean destroy() {
        if (this.operationService == null) {
            return true;
        }
        return ((CouchbaseOperationService)this.operationService).destroy();
    }

    public CouchbaseOperationService getOperationService() {
        return (CouchbaseOperationService)this.operationService;
    }

    public void addDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.add(subscriber);
    }

    public void removeDeleteSubscriber(DeleteNotifier subscriber) {
        this.subscribers.remove(subscriber);
    }

    public Void merge(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        return this.merge(entry, false, false, null);
    }

    protected <T> void updateMergeChanges(String baseDn, T entry, boolean isConfigurationUpdate, Class<?> entryClass, Map<String, AttributeData> attributesFromDbMap, List<AttributeDataModification> attributeDataModifications) {
        if (!isConfigurationUpdate) {
            Object[] objectClasses = this.getObjectClasses(entry, entryClass);
            if (ArrayHelper.isEmpty((Object[])objectClasses)) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses to persist! Entry is invalid: '%s'", entry));
            }
            AttributeData objectClassAttributeData = attributesFromDbMap.get("objectClass".toLowerCase());
            if (objectClassAttributeData == null) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses in DB! Entry is invalid: '%s'", entry));
            }
            Object[] objectClassesFromDb = objectClassAttributeData.getStringValues();
            if (ArrayHelper.isEmpty((Object[])objectClassesFromDb)) {
                throw new UnsupportedOperationException(String.format("There is no attribute with objectClasses in DB! Entry is invalid: '%s'", entry));
            }
            if (!StringHelper.equals((String)objectClassesFromDb[0], (String)objectClasses[0])) {
                attributeDataModifications.add(new AttributeDataModification(AttributeDataModification.AttributeModificationType.REPLACE, new AttributeData("objectClass", objectClasses, Boolean.valueOf(false)), new AttributeData("objectClass", objectClassesFromDb, Boolean.valueOf(false))));
            }
        }
    }

    public void remove(Object entry) {
        Class<?> entryClass = entry.getClass();
        this.checkEntryClass(entryClass, true);
        if (this.isSchemaEntry(entryClass)) {
            throw new UnsupportedOperationException("Server doesn't support dynamic schema modifications");
        }
        Object dnValue = this.getDNValue(entry, entryClass);
        LOG.debug("LDAP entry to remove: '{}'", (Object)dnValue.toString());
        this.remove(dnValue.toString());
    }

    protected void persist(String dn, List<AttributeData> attributes, Integer expiration) {
        JsonObject jsonObject = JsonObject.create();
        for (AttributeData attribute : attributes) {
            String attributeName = attribute.getName();
            Object[] attributeValues = attribute.getValues();
            Boolean multiValued = attribute.getMultiValued();
            if (!ArrayHelper.isNotEmpty((Object[])attributeValues) || attributeValues[0] == null) continue;
            Object[] realValues = attributeValues;
            if (StringHelper.equals((String)"objectClass", (String)attributeName) && !ArrayHelper.isEmpty((Object[])realValues)) {
                realValues = new Object[]{realValues[0]};
                multiValued = false;
            }
            if (StringHelper.equals((String)"userPassword", (String)attributeName)) {
                realValues = this.getOperationService().createStoragePassword(StringHelper.toStringArray((Object[])attributeValues));
            }
            this.escapeValues(realValues);
            if (multiValued == null || !multiValued.booleanValue()) {
                jsonObject.put(this.toInternalAttribute(attributeName), realValues[0]);
                continue;
            }
            jsonObject.put(this.toInternalAttribute(attributeName), JsonArray.from((Object[])realValues));
        }
        jsonObject.put("dn", dn);
        try {
            boolean result = this.getOperationService().addEntry(this.toCouchbaseKey(dn).getKey(), jsonObject, expiration);
            if (!result) {
                throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to persist entry: %s", dn), (Throwable)ex);
        }
    }

    public void merge(String dn, List<AttributeDataModification> attributeDataModifications, Integer expirationValue) {
        try {
            boolean result;
            ArrayList<MutationSpec> modifications = new ArrayList<MutationSpec>(attributeDataModifications.size());
            for (AttributeDataModification attributeDataModification : attributeDataModifications) {
                AttributeData attribute = attributeDataModification.getAttribute();
                AttributeData oldAttribute = attributeDataModification.getOldAttribute();
                String attributeName = null;
                Object[] attributeValues = null;
                Boolean multiValued = null;
                if (attribute != null) {
                    attributeName = attribute.getName();
                    attributeValues = attribute.getValues();
                    multiValued = attribute.getMultiValued();
                }
                String oldAttributeName = null;
                Object[] oldAttributeValues = null;
                if (oldAttribute != null) {
                    oldAttributeName = oldAttribute.getName();
                    oldAttributeValues = oldAttribute.getValues();
                }
                MutationSpec modification = null;
                if (AttributeDataModification.AttributeModificationType.ADD.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.DICT_ADD, this.toInternalAttribute(attributeName), multiValued, attributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REMOVE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.DELETE, this.toInternalAttribute(oldAttributeName), multiValued, oldAttributeValues);
                } else if (AttributeDataModification.AttributeModificationType.REPLACE.equals((Object)attributeDataModification.getModificationType())) {
                    modification = this.createModification(Mutation.REPLACE, this.toInternalAttribute(attributeName), multiValued, attributeValues);
                }
                if (modification == null) continue;
                modifications.add(modification);
            }
            if (modifications.size() > 0 && !(result = this.getOperationService().updateEntry(this.toCouchbaseKey(dn).getKey(), modifications, expirationValue))) {
                throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to update entry: %s", dn), (Throwable)ex);
        }
    }

    public void remove(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.getOperationService().delete(this.toCouchbaseKey(dn).getKey());
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    public void removeRecursively(String dn) {
        try {
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onBeforeRemove(dn);
            }
            this.getOperationService().deleteRecursively(this.toCouchbaseKey(dn).getKey());
            for (DeleteNotifier subscriber : this.subscribers) {
                subscriber.onAfterRemove(dn);
            }
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to remove entry: %s", dn), (Throwable)ex);
        }
    }

    public <T> int remove(String dn, Class<T> entryClass, Filter filter, int count) {
        if (StringHelper.isEmptyString((Object)dn)) {
            throw new MappingException("Base DN to delete entries is null");
        }
        return this.removeImpl(dn, entryClass, filter, count);
    }

    protected <T> int removeImpl(String dn, Class<T> entryClass, Filter filter, int count) {
        ConvertedExpression convertedExpression;
        Filter searchFilter;
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        if (objectClasses.length > 0) {
            LOG.trace("Filter: {}", (Object)filter);
            searchFilter = this.addObjectClassFilter(filter, objectClasses);
        } else {
            searchFilter = filter;
        }
        LOG.trace("-------------------------------------------------------");
        LOG.trace("Filter: {}", (Object)filter);
        LOG.trace("objectClasses count: {} ", (Object)objectClasses.length);
        LOG.trace("objectClasses: {}", (Object)objectClasses.toString());
        LOG.trace("Search filter: {}", (Object)searchFilter);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        ParsedKey keyWithInum = this.toCouchbaseKey(dn);
        try {
            convertedExpression = this.toCouchbaseFilter(searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryDeleteException(String.format("Failed to convert filter %s to expression", searchFilter));
        }
        try {
            int processed = this.getOperationService().delete(keyWithInum.getKey(), this.getScanConsistency(convertedExpression), convertedExpression.expression(), count);
            return processed;
        }
        catch (Exception ex) {
            throw new EntryDeleteException(String.format("Failed to delete entries with key: %s, expression: %s", keyWithInum.getKey(), convertedExpression), (Throwable)ex);
        }
    }

    protected List<AttributeData> find(String dn, Map<String, PropertyAnnotation> propertiesAnnotationsMap, String ... ldapReturnAttributes) {
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(dn);
            ScanConsistency scanConsistency = this.getScanConsistency(keyWithInum.getName(), propertiesAnnotationsMap);
            JsonObject entry = this.getOperationService().lookup(keyWithInum.getKey(), scanConsistency, this.toInternalAttributes(ldapReturnAttributes));
            List<AttributeData> result = this.getAttributeDataList(entry);
            if (result != null) {
                return result;
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
        throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn));
    }

    public <T> List<T> findEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, BatchOperation<T> batchOperation, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<JsonObject> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, scope, ldapReturnAttributes, null, null, batchOperation, SearchReturnDataType.SEARCH, start, count, chunkSize);
        if (searchResult.getEntriesCount() == 0) {
            return new ArrayList(0);
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        return entries;
    }

    public <T> PagedResult<T> findPagedEntries(String baseDN, Class<T> entryClass, Filter filter, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, int start, int count, int chunkSize) {
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        PagedResult<JsonObject> searchResult = this.findEntriesImpl(baseDN, entryClass, filter, SearchScope.SUB, ldapReturnAttributes, sortBy, sortOrder, null, SearchReturnDataType.SEARCH_COUNT, start, count, chunkSize);
        PagedResult result = new PagedResult();
        result.setEntriesCount(searchResult.getEntriesCount());
        result.setStart(searchResult.getStart());
        result.setTotalEntriesCount(searchResult.getTotalEntriesCount());
        if (searchResult.getEntriesCount() == 0) {
            result.setEntries(new ArrayList(0));
            return result;
        }
        List<T> entries = this.createEntities(baseDN, entryClass, searchResult);
        result.setEntries(entries);
        return result;
    }

    protected <T> PagedResult<JsonObject> findEntriesImpl(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope, String[] ldapReturnAttributes, String sortBy, SortOrder sortOrder, BatchOperation<T> batchOperation, SearchReturnDataType returnDataType, int start, int count, int chunkSize) {
        ConvertedExpression convertedExpression;
        Filter searchFilter;
        this.checkEntryClass(entryClass, false);
        Object[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Object[] currentLdapReturnAttributes = ldapReturnAttributes;
        if (ArrayHelper.isEmpty((Object[])currentLdapReturnAttributes)) {
            currentLdapReturnAttributes = this.getAttributes(null, propertiesAnnotations, false);
        }
        if (objectClasses.length > 0) {
            LOG.trace("Filter: {}", (Object)filter);
            searchFilter = this.addObjectClassFilter(filter, (String[])objectClasses);
        } else {
            searchFilter = filter;
        }
        LOG.trace("-------------------------------------------------------");
        LOG.trace("Filter: {}", (Object)filter);
        LOG.trace("objectClasses count: {} ", (Object)objectClasses.length);
        LOG.trace("objectClasses: {}", (Object)ArrayHelper.toString((Object[])objectClasses));
        LOG.trace("Search filter: {}", (Object)searchFilter);
        Object[] defaultSort = this.getDefaultSort(entryClass);
        if (StringHelper.isNotEmpty((String)sortBy)) {
            Sort requestedSort = this.buildSort(sortBy, sortOrder);
            defaultSort = ArrayHelper.isEmpty((Object[])defaultSort) ? new Sort[]{requestedSort} : (Sort[])ArrayHelper.arrayMerge((Object[][])new Sort[][]{{requestedSort}, defaultSort});
        }
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        ParsedKey keyWithInum = this.toCouchbaseKey(baseDN);
        try {
            convertedExpression = this.toCouchbaseFilter(searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter %s to expression", searchFilter));
        }
        PagedResult<JsonObject> searchResult = null;
        try {
            CouchbaseBatchOperationWraper<T> batchOperationWraper = null;
            if (batchOperation != null) {
                batchOperationWraper = new CouchbaseBatchOperationWraper<T>(batchOperation, this, entryClass, propertiesAnnotations);
            }
            if ((searchResult = this.searchImpl(keyWithInum.getKey(), this.getScanConsistency(convertedExpression), convertedExpression.expression(), scope, (String[])currentLdapReturnAttributes, (Sort[])defaultSort, batchOperationWraper, returnDataType, start, count, chunkSize)) == null) {
                throw new EntryPersistenceException(String.format("Failed to find entries with key: %s, expression: %s", keyWithInum.getKey(), convertedExpression));
            }
            return searchResult;
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entries with key: %s, expression: %s", keyWithInum.getKey(), convertedExpression), (Throwable)ex);
        }
    }

    protected <T> boolean contains(String baseDN, Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, Filter filter, String[] objectClasses, String[] ldapReturnAttributes) {
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to check contain entries is null");
        }
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        try {
            convertedExpression = this.toCouchbaseFilter(searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter %s to expression", searchFilter));
        }
        PagedResult<JsonObject> searchResult = null;
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(baseDN);
            searchResult = this.searchImpl(keyWithInum.getKey(), this.getScanConsistency(convertedExpression), convertedExpression.expression(), SearchScope.SUB, ldapReturnAttributes, null, null, SearchReturnDataType.SEARCH, 1, 1, 0);
            if (searchResult == null) {
                throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter));
            }
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult != null && searchResult.getEntriesCount() > 0;
    }

    private <O> PagedResult<JsonObject> searchImpl(String key, ScanConsistency scanConsistency, Expression expression, SearchScope scope, String[] attributes, Sort[] orderBy, CouchbaseBatchOperationWraper<O> batchOperationWraper, SearchReturnDataType returnDataType, int start, int count, int pageSize) throws SearchException {
        return this.getOperationService().search(key, scanConsistency, expression, scope, this.toInternalAttributes(attributes), orderBy, batchOperationWraper, returnDataType, start, count, pageSize);
    }

    protected <T> List<T> createEntities(String baseDN, Class<T> entryClass, PagedResult<JsonObject> searchResult) {
        ParsedKey keyWithInum = this.toCouchbaseKey(baseDN);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        List<T> entries = this.createEntities(entryClass, propertiesAnnotations, keyWithInum, searchResult.getEntries().toArray(new JsonObject[searchResult.getEntriesCount()]));
        return entries;
    }

    protected <T> List<T> createEntities(Class<T> entryClass, List<PropertyAnnotation> propertiesAnnotations, ParsedKey baseDn, JsonObject ... searchResultEntries) {
        ArrayList result = new ArrayList(searchResultEntries.length);
        LinkedHashMap<String, List<AttributeData>> entriesAttributes = new LinkedHashMap<String, List<AttributeData>>(100);
        int count = 0;
        for (int i = 0; i < searchResultEntries.length; ++i) {
            ++count;
            JsonObject entry = searchResultEntries[i];
            String dn = entry.getString(this.fromInternalAttribute("dn"));
            entriesAttributes.put(dn, this.getAttributeDataList(entry));
            searchResultEntries[i] = null;
            if (count < 100) continue;
            List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
            result.addAll(currentResult);
            entriesAttributes = new LinkedHashMap(100);
            count = 0;
        }
        List currentResult = this.createEntities(entryClass, propertiesAnnotations, entriesAttributes);
        result.addAll(currentResult);
        return result;
    }

    private List<AttributeData> getAttributeDataList(JsonObject entry) {
        if (entry == null) {
            return null;
        }
        ArrayList<AttributeData> result = new ArrayList<AttributeData>();
        for (String shortAttributeName : entry.getNames()) {
            Object[] attributeValueObjects;
            Object attributeObject = entry.get(shortAttributeName);
            String attributeName = this.fromInternalAttribute(shortAttributeName);
            Boolean multiValued = Boolean.FALSE;
            if (attributeObject == null) {
                Object[] objectArray = NO_OBJECTS;
            }
            if (attributeObject instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)attributeObject;
                ArrayList resultList = new ArrayList(jsonArray.size());
                Iterator it = jsonArray.iterator();
                while (it.hasNext()) {
                    resultList.add(it.next());
                }
                attributeValueObjects = resultList.toArray(NO_OBJECTS);
                multiValued = Boolean.TRUE;
            } else if (attributeObject instanceof Boolean || attributeObject instanceof Integer || attributeObject instanceof Long || attributeObject instanceof JsonObject) {
                attributeValueObjects = new Object[]{attributeObject};
            } else if (attributeObject instanceof String) {
                Date valueAsDate = this.decodeTime(null, attributeObject.toString());
                Object value = valueAsDate == null ? attributeObject.toString() : valueAsDate;
                attributeValueObjects = new Object[]{value};
            } else {
                String value = attributeObject.toString();
                attributeValueObjects = new Object[]{value};
            }
            this.unescapeValues(attributeValueObjects);
            AttributeData tmpAttribute = new AttributeData(attributeName, attributeValueObjects);
            if (multiValued != null) {
                tmpAttribute.setMultiValued(multiValued);
            }
            result.add(tmpAttribute);
        }
        return result;
    }

    public <T> boolean authenticate(String baseDN, Class<T> entryClass, String userName, String password) {
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Filter searchFilter = Filter.createEqualityFilter((Filter)Filter.createLowercaseFilter((String)"uid"), (Object)StringHelper.toLowerCase((String)userName));
        if (objectClasses.length > 0) {
            searchFilter = this.addObjectClassFilter(searchFilter, objectClasses);
        }
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        try {
            convertedExpression = this.toCouchbaseFilter(searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter %s to expression", searchFilter));
        }
        try {
            PagedResult<JsonObject> searchResult = this.searchImpl(this.toCouchbaseKey(baseDN).getKey(), this.getScanConsistency(convertedExpression), convertedExpression.expression(), SearchScope.SUB, null, null, null, SearchReturnDataType.SEARCH, 0, 1, 1);
            if (searchResult == null || searchResult.getEntriesCount() != 1) {
                return false;
            }
            String bindDn = ((JsonObject)searchResult.getEntries().get(0)).getString("dn");
            return this.authenticate(bindDn, password);
        }
        catch (SearchException ex) {
            throw new AuthenticationException(String.format("Failed to find user DN: %s", userName), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate user: %s", userName), (Throwable)ex);
        }
    }

    public boolean authenticate(String bindDn, String password) {
        try {
            return this.getOperationService().authenticate(this.toCouchbaseKey(bindDn).getKey(), this.escapeValue(password));
        }
        catch (Exception ex) {
            throw new AuthenticationException(String.format("Failed to authenticate DN: %s", bindDn), (Throwable)ex);
        }
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter) {
        return this.countEntries(baseDN, entryClass, filter, SearchScope.SUB);
    }

    public <T> int countEntries(String baseDN, Class<T> entryClass, Filter filter, SearchScope scope) {
        PagedResult<JsonObject> searchResult;
        ConvertedExpression convertedExpression;
        if (StringHelper.isEmptyString((Object)baseDN)) {
            throw new MappingException("Base DN to find entries is null");
        }
        this.checkEntryClass(entryClass, false);
        String[] objectClasses = this.getTypeObjectClasses(entryClass);
        List propertiesAnnotations = this.getEntryPropertyAnnotations(entryClass);
        Filter searchFilter = objectClasses.length > 0 ? this.addObjectClassFilter(filter, objectClasses) : filter;
        Map propertiesAnnotationsMap = this.prepareEntryPropertiesTypes(entryClass, propertiesAnnotations);
        try {
            convertedExpression = this.toCouchbaseFilter(searchFilter, propertiesAnnotationsMap);
        }
        catch (SearchException ex) {
            throw new EntryPersistenceException(String.format("Failed to convert filter %s to expression", searchFilter));
        }
        try {
            searchResult = this.searchImpl(this.toCouchbaseKey(baseDN).getKey(), this.getScanConsistency(convertedExpression), convertedExpression.expression(), scope, null, null, null, SearchReturnDataType.COUNT, 0, 0, 0);
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to calculate the number of entries with baseDN: %s, filter: %s", baseDN, searchFilter), (Throwable)ex);
        }
        return searchResult.getTotalEntriesCount();
    }

    private MutationSpec createModification(Mutation type, String attributeName, Boolean multiValued, Object ... attributeValues) {
        String realAttributeName = attributeName;
        Object[] realValues = attributeValues;
        if (StringHelper.equals((String)"userPassword", (String)realAttributeName)) {
            realValues = this.getOperationService().createStoragePassword(StringHelper.toStringArray((Object[])attributeValues));
        }
        this.escapeValues(realValues);
        if (multiValued == null || !multiValued.booleanValue()) {
            return new MutationSpec(type, realAttributeName, realValues[0]);
        }
        return new MutationSpec(type, realAttributeName, (Object)realValues);
    }

    protected Sort buildSort(String sortBy, SortOrder sortOrder) {
        Sort requestedSort = null;
        requestedSort = SortOrder.DESCENDING == sortOrder ? Sort.desc((Expression)Expression.path((Object[])new Object[]{sortBy})) : (SortOrder.ASCENDING == sortOrder ? Sort.asc((Expression)Expression.path((Object[])new Object[]{sortBy})) : Sort.def((Expression)Expression.path((Object[])new Object[]{sortBy})));
        return requestedSort;
    }

    protected <T> Sort[] getDefaultSort(Class<T> entryClass) {
        Object[] sortByProperties = this.getEntrySortBy(entryClass);
        if (ArrayHelper.isEmpty((Object[])sortByProperties)) {
            return null;
        }
        Sort[] sort = new Sort[sortByProperties.length];
        for (int i = 0; i < sortByProperties.length; ++i) {
            sort[i] = Sort.def((Expression)Expression.path((Object[])new Object[]{sortByProperties[i]}));
        }
        return sort;
    }

    public List<AttributeData> exportEntry(String dn) {
        try {
            ParsedKey keyWithInum = this.toCouchbaseKey(dn);
            JsonObject entry = this.getOperationService().lookup(keyWithInum.getKey(), null, new String[0]);
            List<AttributeData> result = this.getAttributeDataList(entry);
            if (result != null) {
                return result;
            }
            return null;
        }
        catch (Exception ex) {
            throw new EntryPersistenceException(String.format("Failed to find entry: %s", dn), (Throwable)ex);
        }
    }

    public void importEntry(String dn, List<AttributeData> attributes) {
        this.persist(dn, attributes, 0);
    }

    private ConvertedExpression toCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.FILTER_CONVERTER.convertToCouchbaseFilter(genericFilter, propertiesAnnotationsMap);
    }

    private ConvertedExpression toCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor) throws SearchException {
        return this.FILTER_CONVERTER.convertToCouchbaseFilter(genericFilter, propertiesAnnotationsMap, processor);
    }

    private ParsedKey toCouchbaseKey(String dn) {
        return KEY_CONVERTER.convertToKey(dn);
    }

    protected Filter addObjectClassFilter(Filter filter, String[] objectClasses) {
        if (objectClasses.length == 0) {
            return filter;
        }
        Filter searchFilter = Filter.createEqualityFilter((String)"objectClass", (Object)objectClasses[0]);
        if (filter != null) {
            searchFilter = Filter.createANDFilter((Filter[])new Filter[]{Filter.createANDFilter((Filter[])new Filter[]{searchFilter}), filter});
        }
        return searchFilter;
    }

    public String encodeTime(String baseDN, Date date) {
        if (date == null) {
            return null;
        }
        try {
            String utcDate = DateTimeFormatter.ISO_INSTANT.format(Instant.ofEpochMilli(date.getTime()));
            return utcDate.substring(0, utcDate.length() - 1);
        }
        catch (DateTimeException ex) {
            LOG.error("Cannot format date '{}' as ISO", (Object)date, (Object)ex);
            return null;
        }
    }

    protected String encodeTime(Date date) {
        return this.encodeTime(null, date);
    }

    public Date decodeTime(String baseDN, String date) {
        if (StringHelper.isEmpty((String)date)) {
            return null;
        }
        String dateZ = date.endsWith("Z") ? date : date + "Z";
        try {
            return new Date(Instant.parse(dateZ).toEpochMilli());
        }
        catch (DateTimeParseException ex) {
            LOG.error("Failed to decode generalized time '{}'", (Object)date, (Object)ex);
            return null;
        }
    }

    public Date decodeTime(String date) {
        return this.decodeTime(null, date);
    }

    public boolean hasBranchesSupport(String dn) {
        return false;
    }

    public boolean hasExpirationSupport(String primaryKey) {
        return true;
    }

    public String getPersistenceType() {
        return "couchbase";
    }

    public String getPersistenceType(String primaryKey) {
        return "couchbase";
    }

    public PersistenceEntryManager getPersistenceEntryManager(String persistenceType) {
        if ("couchbase".equals(persistenceType)) {
            return this;
        }
        return null;
    }

    protected Object convertValueToJson(Object propertyValue) {
        String jsonStringPropertyValue = (String)super.convertValueToJson(propertyValue);
        return JsonObject.fromJson((String)jsonStringPropertyValue);
    }

    protected Object convertJsonToValue(Class<?> parameterType, Object propertyValue) {
        Object jsonStringPropertyValue = propertyValue;
        if (propertyValue instanceof JsonObject) {
            JsonObject jsonObject = (JsonObject)propertyValue;
            jsonStringPropertyValue = jsonObject.toString();
        }
        return super.convertJsonToValue(parameterType, jsonStringPropertyValue);
    }

    private ScanConsistency getScanConsistency(ConvertedExpression convertedExpression) {
        if (convertedExpression.consistency()) {
            return ScanConsistency.REQUEST_PLUS;
        }
        return null;
    }

    private ScanConsistency getScanConsistency(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (StringHelper.isEmpty((String)attributeName)) {
            return null;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        AttributeName attributeNameAnnotation = (AttributeName)ReflectHelper.getAnnotationByType((List)propertyAnnotation.getAnnotations(), AttributeName.class);
        if (attributeNameAnnotation.consistency()) {
            return ScanConsistency.REQUEST_PLUS;
        }
        return null;
    }

    private String escapeValue(String value) {
        return value;
    }

    private String unescapeValue(String value) {
        return value;
    }

    private void escapeValues(Object[] realValues) {
    }

    private void unescapeValues(Object[] realValues) {
    }

    public String toInternalAttribute(String attributeName) {
        return attributeName;
    }

    public String[] toInternalAttributes(String[] attributeNames) {
        return attributeNames;
    }

    public String fromInternalAttribute(String internalAttributeName) {
        return internalAttributeName;
    }

    public String[] fromInternalAttributes(String[] internalAttributeNames) {
        return internalAttributeNames;
    }

    private static final class CountBatchOperation<T>
    extends DefaultBatchOperation<T> {
        private int countEntries = 0;

        private CountBatchOperation() {
        }

        public void performAction(List<T> entries) {
        }

        public boolean collectSearchResult(int size) {
            this.countEntries += size;
            return false;
        }

        public int getCountEntries() {
            return this.countEntries;
        }
    }
}

