/*
 * Decompiled with CFR 0.152.
 */
package org.gluu.persist.couchbase.impl;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.query.dsl.Expression;
import com.couchbase.client.java.query.dsl.functions.Collections;
import com.couchbase.client.java.query.dsl.functions.StringFunctions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.gluu.persist.annotation.AttributeEnum;
import org.gluu.persist.annotation.AttributeName;
import org.gluu.persist.couchbase.impl.CouchbaseEntryManager;
import org.gluu.persist.couchbase.model.ConvertedExpression;
import org.gluu.persist.exception.operation.SearchException;
import org.gluu.persist.ldap.impl.LdapFilterConverter;
import org.gluu.persist.reflect.property.PropertyAnnotation;
import org.gluu.persist.reflect.util.ReflectHelper;
import org.gluu.search.filter.Filter;
import org.gluu.search.filter.FilterType;
import org.gluu.util.ArrayHelper;
import org.gluu.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseFilterConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseFilterConverter.class);
    private LdapFilterConverter ldapFilterConverter = new LdapFilterConverter();
    private CouchbaseEntryManager couchbaseEntryManager;

    public CouchbaseFilterConverter(CouchbaseEntryManager couchbaseEntryManager) {
        this.couchbaseEntryManager = couchbaseEntryManager;
    }

    public ConvertedExpression convertToCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) throws SearchException {
        return this.convertToCouchbaseFilter(genericFilter, propertiesAnnotationsMap, null);
    }

    public ConvertedExpression convertToCouchbaseFilter(Filter genericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap, Function<? super Filter, Boolean> processor) throws SearchException {
        String internalAttribute;
        Filter currentGenericFilter = genericFilter;
        FilterType type = currentGenericFilter.getType();
        if (FilterType.RAW == type) {
            LOG.warn("RAW Ldap filter to Couchbase convertion will be removed in new version!!!");
            currentGenericFilter = this.ldapFilterConverter.convertRawLdapFilterToFilter(currentGenericFilter.getFilterString());
            type = currentGenericFilter.getType();
        }
        boolean requiredConsistency = this.isRequiredConsistency(currentGenericFilter, propertiesAnnotationsMap);
        if (processor != null) {
            processor.apply((Filter)currentGenericFilter);
        }
        if (FilterType.NOT == type || FilterType.AND == type || FilterType.OR == type) {
            Filter[] genericFilters = currentGenericFilter.getFilters();
            ConvertedExpression[] expFilters = new ConvertedExpression[genericFilters.length];
            if (genericFilters != null) {
                int i;
                boolean canJoinOrFilters = FilterType.OR == type;
                ArrayList<Filter> joinOrFilters = new ArrayList<Filter>();
                String joinOrAttributeName = null;
                for (i = 0; i < genericFilters.length; ++i) {
                    Filter tmpFilter = genericFilters[i];
                    expFilters[i] = this.convertToCouchbaseFilter(tmpFilter, propertiesAnnotationsMap, processor);
                    if (!canJoinOrFilters) continue;
                    if (tmpFilter.getMultiValued() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (FilterType.EQUALITY != tmpFilter.getType() || tmpFilter.getFilters() != null) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    Boolean isMultiValuedDetected = this.determineMultiValuedByType(tmpFilter.getAttributeName(), propertiesAnnotationsMap);
                    if (!Boolean.FALSE.equals(isMultiValuedDetected)) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    if (joinOrAttributeName == null) {
                        joinOrAttributeName = tmpFilter.getAttributeName();
                        joinOrFilters.add(tmpFilter);
                        continue;
                    }
                    if (!joinOrAttributeName.equals(tmpFilter.getAttributeName())) {
                        canJoinOrFilters = false;
                        continue;
                    }
                    joinOrFilters.add(tmpFilter);
                }
                if (FilterType.NOT == type) {
                    return ConvertedExpression.build(Expression.par((Expression)expFilters[0].expression().not()), expFilters[0].consistency());
                }
                if (FilterType.AND == type) {
                    for (i = 0; i < expFilters.length; ++i) {
                        requiredConsistency |= expFilters[i].consistency();
                    }
                    Expression result = expFilters[0].expression();
                    for (int i2 = 1; i2 < expFilters.length; ++i2) {
                        result = result.and(expFilters[i2].expression());
                    }
                    return ConvertedExpression.build(Expression.par((Expression)result), requiredConsistency);
                }
                if (FilterType.OR == type) {
                    for (i = 0; i < expFilters.length; ++i) {
                        requiredConsistency |= expFilters[i].consistency();
                    }
                    if (canJoinOrFilters) {
                        JsonArray jsonArrayValues = JsonArray.create();
                        for (Filter eqFilter : joinOrFilters) {
                            jsonArrayValues.add(eqFilter.getAssertionValue());
                        }
                        Expression exp = Expression.par((Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{joinOrAttributeName})}).in(jsonArrayValues));
                        return ConvertedExpression.build(exp, requiredConsistency);
                    }
                    Expression result = expFilters[0].expression();
                    for (int i3 = 1; i3 < expFilters.length; ++i3) {
                        result = result.or(expFilters[i3].expression());
                    }
                    return ConvertedExpression.build(Expression.par((Expression)result), requiredConsistency);
                }
            }
        }
        if (FilterType.EQUALITY == type) {
            Expression nameExpression;
            ConvertedExpression nameConvertedExpression;
            ConvertedExpression nameConvertedExpression2;
            boolean hasSubFilters = ArrayHelper.isNotEmpty((Object[])currentGenericFilter.getFilters());
            Boolean isMultiValuedDetected = this.determineMultiValuedByType(currentGenericFilter.getAttributeName(), propertiesAnnotationsMap);
            String internalAttribute2 = this.toInternalAttribute(currentGenericFilter);
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                if (hasSubFilters) {
                    Filter clonedFilter = currentGenericFilter.getFilters()[0];
                    clonedFilter.setAttributeName(internalAttribute2 + "_");
                    nameConvertedExpression2 = this.convertToCouchbaseFilter(clonedFilter, propertiesAnnotationsMap);
                    return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute2 + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute2})})).satisfies(nameConvertedExpression2.expression().eq(this.buildTypedExpression(currentGenericFilter))), requiredConsistency);
                }
                return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute2 + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute2})})).satisfies(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute2 + "_"}).eq(this.buildTypedExpression(currentGenericFilter))})), requiredConsistency);
            }
            if (Boolean.FALSE.equals(currentGenericFilter.getMultiValued()) || Boolean.FALSE.equals(isMultiValuedDetected)) {
                if (hasSubFilters) {
                    nameConvertedExpression = this.convertToCouchbaseFilter(currentGenericFilter.getFilters()[0], propertiesAnnotationsMap);
                    return ConvertedExpression.build(nameConvertedExpression.expression().eq(this.buildTypedExpression(currentGenericFilter)), requiredConsistency);
                }
                return ConvertedExpression.build(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{this.toInternalAttribute(currentGenericFilter)})}).eq(this.buildTypedExpression(currentGenericFilter)), requiredConsistency);
            }
            if (hasSubFilters && isMultiValuedDetected == null) {
                nameConvertedExpression = this.convertToCouchbaseFilter(currentGenericFilter.getFilters()[0], propertiesAnnotationsMap);
                return ConvertedExpression.build(nameConvertedExpression.expression().eq(this.buildTypedExpression(currentGenericFilter)), nameConvertedExpression.consistency() || requiredConsistency);
            }
            if (hasSubFilters) {
                nameConvertedExpression2 = this.convertToCouchbaseFilter(currentGenericFilter.getFilters()[0], propertiesAnnotationsMap);
                nameExpression = nameConvertedExpression2.expression();
            } else {
                nameExpression = Expression.path((Object[])new Object[]{this.toInternalAttribute(currentGenericFilter)});
            }
            Expression exp1 = Expression.par((Expression)Expression.path((Object[])new Object[]{nameExpression}).eq(this.buildTypedExpression(currentGenericFilter)));
            Expression exp2 = Expression.par((Expression)Expression.path((Object[])new Object[]{this.buildTypedExpression(currentGenericFilter)}).in(nameExpression));
            return ConvertedExpression.build(Expression.par((Expression)exp1.or(exp2)), requiredConsistency);
        }
        if (FilterType.LESS_OR_EQUAL == type) {
            internalAttribute = this.toInternalAttribute(currentGenericFilter);
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})})).satisfies(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute + "_"})}).lte(this.buildTypedExpression(currentGenericFilter))), requiredConsistency);
            }
            return ConvertedExpression.build(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})}).lte(this.buildTypedExpression(currentGenericFilter)), requiredConsistency);
        }
        if (FilterType.GREATER_OR_EQUAL == type) {
            internalAttribute = this.toInternalAttribute(currentGenericFilter);
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})})).satisfies(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute + "_"})}).gte(this.buildTypedExpression(currentGenericFilter))), requiredConsistency);
            }
            return ConvertedExpression.build(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})}).gte(this.buildTypedExpression(currentGenericFilter)), requiredConsistency);
        }
        if (FilterType.PRESENCE == type) {
            internalAttribute = this.toInternalAttribute(currentGenericFilter);
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})})).satisfies(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute + "_"})}).isNotMissing()), requiredConsistency);
            }
            return ConvertedExpression.build(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute})}).isNotMissing(), requiredConsistency);
        }
        if (FilterType.APPROXIMATE_MATCH == type) {
            throw new SearchException("Convertion from APPROXIMATE_MATCH LDAP filter to Couchbase filter is not implemented");
        }
        if (FilterType.SUBSTRING == type) {
            StringBuilder like = new StringBuilder();
            if (currentGenericFilter.getSubInitial() != null) {
                like.append(currentGenericFilter.getSubInitial());
            }
            like.append("%");
            String[] subAny = currentGenericFilter.getSubAny();
            if (subAny != null && subAny.length > 0) {
                for (String any : subAny) {
                    like.append(any);
                    like.append("%");
                }
            }
            if (currentGenericFilter.getSubFinal() != null) {
                like.append(currentGenericFilter.getSubFinal());
            }
            if (this.isMultiValue(currentGenericFilter, propertiesAnnotationsMap).booleanValue()) {
                String internalAttribute3 = this.toInternalAttribute(currentGenericFilter);
                return ConvertedExpression.build(Collections.anyIn((String)(internalAttribute3 + "_"), (Expression)Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{this.toInternalAttribute(currentGenericFilter)})})).satisfies(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{internalAttribute3 + "_"})}).like(Expression.s((String[])new String[]{StringHelper.escapeJson((Object)like.toString())}))), requiredConsistency);
            }
            return ConvertedExpression.build(Expression.path((Object[])new Object[]{Expression.path((Object[])new Object[]{this.toInternalAttribute(currentGenericFilter)}).like(Expression.s((String[])new String[]{StringHelper.escapeJson((Object)like.toString())}))}), requiredConsistency);
        }
        if (FilterType.LOWERCASE == type) {
            return ConvertedExpression.build(StringFunctions.lower((String)currentGenericFilter.getAttributeName()), requiredConsistency);
        }
        throw new SearchException(String.format("Unknown filter type '%s'", type));
    }

    protected Boolean isMultiValue(Filter currentGenericFilter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        Boolean isMultiValuedDetected = this.determineMultiValuedByType(currentGenericFilter.getAttributeName(), propertiesAnnotationsMap);
        if (Boolean.TRUE.equals(currentGenericFilter.getMultiValued()) || Boolean.TRUE.equals(isMultiValuedDetected)) {
            return true;
        }
        return false;
    }

    private String toInternalAttribute(Filter filter) {
        String attributeName = filter.getAttributeName();
        if (StringHelper.isEmpty((String)attributeName)) {
            Filter subFilter;
            Filter[] filterArray = filter.getFilters();
            int n = filterArray.length;
            for (int i = 0; i < n && !StringHelper.isNotEmpty((String)(attributeName = (subFilter = filterArray[i]).getAttributeName())); ++i) {
            }
        }
        if (this.couchbaseEntryManager == null) {
            return attributeName;
        }
        return this.couchbaseEntryManager.toInternalAttribute(attributeName);
    }

    private Expression buildTypedExpression(Filter currentGenericFilter) {
        if (currentGenericFilter.getAssertionValue() instanceof Boolean) {
            return Expression.x((boolean)((Boolean)currentGenericFilter.getAssertionValue()));
        }
        if (currentGenericFilter.getAssertionValue() instanceof Integer) {
            return Expression.x((Number)((Integer)currentGenericFilter.getAssertionValue()));
        }
        if (currentGenericFilter.getAssertionValue() instanceof Long) {
            return Expression.x((Number)((Long)currentGenericFilter.getAssertionValue()));
        }
        return Expression.s((String[])new String[]{StringHelper.escapeJson((Object)currentGenericFilter.getAssertionValue())});
    }

    private Boolean determineMultiValuedByType(String attributeName, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (attributeName == null || propertiesAnnotationsMap == null) {
            return null;
        }
        if (StringHelper.equalsIgnoreCase((String)attributeName, (String)"objectClass")) {
            return false;
        }
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return null;
        }
        Class parameterType = propertyAnnotation.getParameterType();
        boolean isMultiValued = parameterType.equals(String[].class) || ReflectHelper.assignableFrom((Class)parameterType, List.class) || ReflectHelper.assignableFrom((Class)parameterType, AttributeEnum[].class);
        return isMultiValued;
    }

    private boolean isRequiredConsistency(Filter filter, Map<String, PropertyAnnotation> propertiesAnnotationsMap) {
        if (propertiesAnnotationsMap == null) {
            return false;
        }
        String attributeName = filter.getAttributeName();
        PropertyAnnotation propertyAnnotation = propertiesAnnotationsMap.get(attributeName);
        if (propertyAnnotation == null || propertyAnnotation.getParameterType() == null) {
            return false;
        }
        AttributeName attributeNameAnnotation = (AttributeName)ReflectHelper.getAnnotationByType((List)propertyAnnotation.getAnnotations(), AttributeName.class);
        return attributeNameAnnotation.consistency();
    }
}

